<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ConfiguracaoController extends Controller
{
    public function index()
    {
        // Configurações padrão (valores de referência)
        $config = [
            'nome_sistema' => 'Vencer Leitura',
            'email_sistema' => 'contato@vencerleitura.com',
            'telefone_sistema' => '(11) 99999-9999',
            'distribuicao_automatica' => '0',
            'tempo_resposta_lead' => '24',
            'meta_conversao' => '20',
            'comissao_padrao' => '10',
        ];

        return view('admin.configuracoes.index', compact('config'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'nome_sistema' => 'required|string|max:255',
            'email_sistema' => 'required|email',
            'telefone_sistema' => 'nullable|string|max:20',
            'distribuicao_automatica' => 'required|boolean',
            'tempo_resposta_lead' => 'required|integer|min:1',
            'meta_conversao' => 'required|numeric|min:0|max:100',
            'comissao_padrao' => 'required|numeric|min:0|max:100',
        ]);

        // Por enquanto, apenas retorna sucesso
        // Para implementação futura: criar tabela configuracoes_sistema
        return redirect()->route('admin.configuracoes.index')
            ->with('success', 'Configurações visualizadas! (Nota: Para salvar permanentemente, será necessário criar a tabela configuracoes_sistema)');
    }

    public function toggleDistribuicaoAutomatica()
    {
        // Por enquanto, apenas retorna sucesso
        return response()->json([
            'success' => true,
            'message' => 'Funcionalidade disponível após criar tabela configuracoes_sistema',
        ]);
    }
}

