<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class LeadApiController extends Controller
{
    /**
     * Criar lead via API
     */
    public function criar(Request $request)
    {
        // Validar token de API
        $apiKey = $request->header('X-API-Key');
        if ($apiKey !== env('API_KEY_PORTAL_ALUNO')) {
            return response()->json([
                'success' => false,
                'message' => 'Token de API inválido'
            ], 401);
        }

        // Validar dados
        $validator = Validator::make($request->all(), [
            'nome' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'telefone' => 'required|string|max:20',
            'celular' => 'nullable|string|max:20',
            'utm_source' => 'nullable|string|max:100',
            'utm_medium' => 'nullable|string|max:100',
            'utm_campaign' => 'nullable|string|max:100',
            'utm_content' => 'nullable|string|max:100',
            'utm_term' => 'nullable|string|max:100',
            'ref' => 'nullable|string|max:50',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Dados inválidos',
                'errors' => $validator->errors()
            ], 422);
        }

        // Buscar link de marketing pelo código ref
        $linkMarketingId = null;
        if ($request->ref) {
            $linkMarketing = DB::table('links_marketing')
                ->where('codigo', strtoupper($request->ref))
                ->first();
            
            if ($linkMarketing) {
                $linkMarketingId = $linkMarketing->id;
            }
        }

        // Verificar se lead já existe
        $leadExistente = DB::table('leads')
            ->where('email', $request->email)
            ->first();

        if ($leadExistente) {
            return response()->json([
                'success' => false,
                'message' => 'Lead já cadastrado',
                'lead_id' => $leadExistente->id
            ], 409);
        }

        // Criar lead
        $leadId = DB::table('leads')->insertGetId([
            'nome' => $request->nome,
            'email' => $request->email,
            'telefone' => $request->telefone,
            'celular' => $request->celular ?? $request->telefone,
            'link_marketing_id' => $linkMarketingId,
            'origem' => $request->origem ?? 'site_agendamento',
            'status' => 'novo',
            'etapa' => 'novo',
            'data_cadastro' => now(),
            'data_distribuicao' => null,
            'especialista_id' => null,
            'equipe_id' => null,
        ]);

        // Se houver distribuição automática configurada, distribuir o lead
        // (implementar lógica de distribuição automática se necessário)

        return response()->json([
            'success' => true,
            'message' => 'Lead criado com sucesso',
            'lead_id' => $leadId
        ], 201);
    }
}


