<?php

namespace App\Http\Controllers\Especialista;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class LogPagamentoController extends Controller
{
    /**
     * Listar logs de pagamento do especialista
     */
    public function index()
    {
        $especialista = Auth::user();

        // Buscar logs de pagamento
        $logs = DB::table('negociacoes as n')
            ->join('alunos as a', 'n.aluno_id', '=', 'a.id')
            ->leftJoin('vinculo as v', function($join) {
                $join->on('v.aluno_id', '=', 'a.id')
                    ->where('v.status', '=', 'ativo');
            })
            ->leftJoin('leads as l', 'v.lead_id', '=', 'l.id')
            ->where('n.especialista_id', $especialista->id)
            ->select(
                'n.id as negociacao_id',
                'n.valor_total',
                'n.valor_pago',
                'n.saldo_restante',
                'n.status',
                'n.data_criacao',
                'n.data_fechamento',
                'a.nome as aluno_nome',
                'a.email as aluno_email',
                'a.celular as aluno_celular',
                'l.nome as lead_nome'
            )
            ->orderBy('n.data_criacao', 'desc')
            ->limit(50)
            ->get();

        // Estatísticas (ajustadas para colunas existentes)
        $totalLinks = 0; // Não há coluna de link de pagamento
        $totalPagos = $logs->where('status', 'fechado')->where('valor_pago', '>', 0)->count();
        $valorTotal = $logs->sum('valor_total');
        $valorPago = $logs->sum('valor_pago');

        return view('especialista.logs-pagamento.index', compact(
            'logs',
            'totalLinks',
            'totalPagos',
            'valorTotal',
            'valorPago'
        ));
    }
}

