<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LinkRedirectController extends Controller
{
    /**
     * Redireciona para o link de marketing e registra o click
     */
    public function redirect($codigo, Request $request)
    {
        // Buscar link
        $link = DB::table('links_marketing')
            ->where('codigo', strtoupper($codigo))
            ->where('ativo', 1)
            ->first();

        if (!$link) {
            abort(404, 'Link não encontrado ou inativo');
        }

        // Registrar click
        DB::table('clicks_marketing')->insert([
            'link_id' => $link->id,
            'ip' => $request->ip(),
            'user_agent' => $request->userAgent(),
            'referrer' => $request->header('referer'),
            'data_click' => now(),
        ]);

        // A URL completa já está armazenada com todos os parâmetros UTM
        // Apenas redirecionar para a URL completa
        return redirect()->away($link->url_completa);
    }
}

