<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Campanha extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'campanhas_marketing';

    /**
     * Desabilitar timestamps automáticos do Laravel
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nome',
        'descricao',
        'tipo',
        'status',
        'data_inicio',
        'data_fim',
        'orcamento',
        'investimento',
        'criado_por',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data_inicio' => 'date',
        'data_fim' => 'date',
        'orcamento' => 'decimal:2',
        'investimento' => 'decimal:2',
    ];

    /**
     * Relacionamento com Usuario criador
     */
    public function criador()
    {
        return $this->belongsTo(Usuario::class, 'criado_por');
    }

    /**
     * Relacionamento com Leads
     */
    public function leads()
    {
        return $this->hasMany(Lead::class, 'campanha_id');
    }

    /**
     * Verifica se a campanha está ativa
     */
    public function isAtiva(): bool
    {
        return $this->status === 'ativa';
    }
}

