<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Matricula extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'matriculas';

    /**
     * Desabilitar timestamps automáticos do Laravel
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'aluno_id',
        'especialista_id',
        'lead_id',
        'negociacao_id',
        'status',
        'data_matricula',
        'data_inicio',
        'data_fim',
        'observacoes',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data_matricula' => 'date',
        'data_inicio' => 'date',
        'data_fim' => 'date',
    ];

    /**
     * Relacionamento com Aluno
     */
    public function aluno()
    {
        return $this->belongsTo(Aluno::class, 'aluno_id');
    }

    /**
     * Relacionamento com Especialista (Usuario)
     */
    public function especialista()
    {
        return $this->belongsTo(Usuario::class, 'especialista_id');
    }

    /**
     * Relacionamento com Lead
     */
    public function lead()
    {
        return $this->belongsTo(Lead::class, 'lead_id');
    }

    /**
     * Relacionamento com Negociacao
     */
    public function negociacao()
    {
        return $this->belongsTo(Negociacao::class, 'negociacao_id');
    }

    /**
     * Verifica se a matrícula está ativa
     */
    public function isAtiva(): bool
    {
        return $this->status === 'ativa';
    }

    /**
     * Scope para matrículas ativas
     */
    public function scopeAtivas($query)
    {
        return $query->where('status', 'ativa');
    }
}

