<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Turma extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'turmas';

    /**
     * Desabilitar timestamps automáticos do Laravel
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nome',
        'professor_id',
        'status',
        'data_inicio',
        'data_fim',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data_inicio' => 'date',
        'data_fim' => 'date',
    ];

    /**
     * Relacionamento com Professor
     */
    public function professor()
    {
        return $this->belongsTo(Professor::class, 'professor_id');
    }

    /**
     * Relacionamento com Alunos
     */
    public function alunos()
    {
        return $this->hasMany(Aluno::class, 'turma_id');
    }

    /**
     * Verifica se a turma está ativa
     */
    public function isAtiva(): bool
    {
        return $this->status === 'ativa';
    }
}

