<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Voucher extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'vouchers';

    /**
     * Desabilitar timestamps automáticos do Laravel
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'codigo',
        'nome',
        'descricao',
        'tipo',
        'valor_desconto',
        'percentual_desconto',
        'valor_minimo',
        'quantidade_total',
        'quantidade_usada',
        'data_inicio',
        'data_fim',
        'ativo',
        'valor',
        'percentual',
        'limite_uso',
        'validade',
        'status',
        'criado_por',
        'data_criacao',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data_inicio' => 'datetime',
        'data_fim' => 'datetime',
        'validade' => 'date',
        'data_criacao' => 'datetime',
        'valor_desconto' => 'decimal:2',
        'percentual_desconto' => 'decimal:2',
        'valor' => 'decimal:2',
        'percentual' => 'decimal:2',
        'valor_minimo' => 'decimal:2',
        'ativo' => 'boolean',
    ];

    /**
     * Relacionamento com Usuario que criou
     */
    public function criador()
    {
        return $this->belongsTo(Usuario::class, 'criado_por');
    }

    /**
     * Verifica se o voucher está ativo
     */
    public function isAtivo(): bool
    {
        return $this->ativo == 1 && 
               $this->status === 'ativo' &&
               ($this->validade === null || $this->validade >= now()->format('Y-m-d'));
    }

    /**
     * Verifica se o voucher foi usado
     */
    public function isUsado(): bool
    {
        return $this->quantidade_usada > 0;
    }

    /**
     * Verifica se ainda tem quantidade disponível
     */
    public function temDisponivel(): bool
    {
        return $this->quantidade_usada < $this->quantidade_total;
    }
}

