<?php
// Conexão e consulta de dados
$especialista_id = $_SESSION['especialista_id'];

// KPIs
// Total de Vendas
$stmt_vendas = $pdo->prepare("SELECT SUM(valor_total) as total_vendas FROM negociacoes WHERE especialista_id = ? AND status = 'aprovada'");
$stmt_vendas->execute([$especialista_id]);
$total_vendas = $stmt_vendas->fetchColumn();

// Novos Alunos (este mês)
$stmt_alunos = $pdo->prepare("SELECT COUNT(DISTINCT aluno_id) FROM negociacoes WHERE especialista_id = ? AND status = 'aprovada' AND MONTH(data_criacao) = MONTH(NOW()) AND YEAR(data_criacao) = YEAR(NOW())");
$stmt_alunos->execute([$especialista_id]);
$novos_alunos = $stmt_alunos->fetchColumn();

// Taxa de Conversão (Aprovadas / Total)
$stmt_total_negociacoes = $pdo->prepare("SELECT COUNT(*) FROM negociacoes WHERE especialista_id = ?");
$stmt_total_negociacoes->execute([$especialista_id]);
$total_negociacoes = $stmt_total_negociacoes->fetchColumn();

$stmt_aprovadas = $pdo->prepare("SELECT COUNT(*) FROM negociacoes WHERE especialista_id = ? AND status = 'aprovada'");
$stmt_aprovadas->execute([$especialista_id]);
$negociacoes_aprovadas = $stmt_aprovadas->fetchColumn();

$taxa_conversao = ($total_negociacoes > 0) ? ($negociacoes_aprovadas / $total_negociacoes) * 100 : 0;

// Ticket Médio
$ticket_medio = ($negociacoes_aprovadas > 0) ? $total_vendas / $negociacoes_aprovadas : 0;

// Dados para o gráfico de vendas (últimos 6 meses)
$vendas_mes = [];
$meses = [];
for ($i = 5; $i >= 0; $i--) {
    $mes = date('Y-m', strtotime("-$i month"));
    $stmt = $pdo->prepare("SELECT SUM(valor_total) FROM negociacoes WHERE especialista_id = ? AND status = 'aprovada' AND DATE_FORMAT(data_criacao, '%Y-%m') = ?");
    $stmt->execute([$especialista_id, $mes]);
    $vendas_mes[] = $stmt->fetchColumn() ?: 0;
    $meses[] = date('M/y', strtotime("-$i month"));
}

// Ranking de Especialistas
$stmt_ranking = $pdo->prepare("
    SELECT e.nome, SUM(n.valor_total) as total_vendido
    FROM negociacoes n
    JOIN especialistas e ON n.especialista_id = e.id
    WHERE n.status = 'aprovada'
    GROUP BY e.id, e.nome
    ORDER BY total_vendido DESC
    LIMIT 5
");
$stmt_ranking->execute();
$ranking_especialistas = $stmt_ranking->fetchAll();

// Últimas Matrículas
$stmt_ultimas = $pdo->prepare("
    SELECT a.nome, n.valor_total, n.data_criacao
    FROM negociacoes n
    JOIN alunos a ON n.aluno_id = a.id
    WHERE n.especialista_id = ? AND n.status = 'aprovada'
    ORDER BY n.data_criacao DESC
    LIMIT 5
");
$stmt_ultimas->execute([$especialista_id]);
$ultimas_matriculas = $stmt_ultimas->fetchAll();
?>

<div class="container-fluid">
    <!-- KPIs -->
    <div class="row">
        <div class="col-md-3 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title text-muted">Total de Vendas</h5>
                    <p class="card-text fs-4 fw-bold">R$ <?php echo number_format($total_vendas, 2, ',', '.'); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title text-muted">Novos Alunos (Mês)</h5>
                    <p class="card-text fs-4 fw-bold"><?php echo $novos_alunos; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title text-muted">Taxa de Conversão</h5>
                    <p class="card-text fs-4 fw-bold"><?php echo number_format($taxa_conversao, 2); ?>%</p>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title text-muted">Ticket Médio</h5>
                    <p class="card-text fs-4 fw-bold">R$ <?php echo number_format($ticket_medio, 2, ',', '.'); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráfico de Vendas e Ações Rápidas -->
    <div class="row">
        <div class="col-md-8 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Vendas nos Últimos 6 Meses</h5>
                    <canvas id="vendasChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Ações Rápidas</h5>
                    <div class="d-grid gap-2">
                        <a href="index.php?page=nova_negociacao" class="btn btn-primary"><i class="fas fa-plus me-2"></i>Nova Matrícula</a>
                        <a href="index.php?page=relatorios" class="btn btn-secondary"><i class="fas fa-chart-bar me-2"></i>Ver Relatórios</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Ranking e Últimas Matrículas -->
    <div class="row">
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Ranking de Especialistas</h5>
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Especialista</th>
                                <th>Vendas</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($ranking_especialistas as $index => $espec): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo htmlspecialchars($espec['nome']); ?></td>
                                <td>R$ <?php echo number_format($espec['total_vendido'], 2, ',', '.'); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">Últimas Matrículas</h5>
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Aluno</th>
                                <th>Valor</th>
                                <th>Data</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($ultimas_matriculas as $matricula): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($matricula['nome']); ?></td>
                                <td>R$ <?php echo number_format($matricula['valor_total'], 2, ',', '.'); ?></td>
                                <td><?php echo date('d/m/Y', strtotime($matricula['data_criacao'])); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var ctx = document.getElementById('vendasChart').getContext('2d');
    var vendasChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($meses); ?>,
            datasets: [{
                label: 'Vendas (R$)',
                data: <?php echo json_encode($vendas_mes); ?>,
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
});
</script>
