<?php
$especialista_id = $_SESSION['especialista_id'];

// Buscar informações do especialista
$stmt = $pdo->prepare("SELECT nome FROM especialistas WHERE id = ?");
$stmt->execute([$especialista_id]);
$especialista = $stmt->fetch();

// Gerar links únicos para cada tipo de aluno
$link_regular = "http://" . $_SERVER['HTTP_HOST'] . "/portal/cadastro.php?e=" . $especialista_id . "&tipo=regular";
$link_bolsista = "http://" . $_SERVER['HTTP_HOST'] . "/portal/cadastro.php?e=" . $especialista_id . "&tipo=bolsista";
?>

<div class="custom-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-link me-2"></i>
            Meus Links de Cadastro
        </h5>
    </div>
    <div class="card-body">
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i>
            <strong>Links Únicos:</strong> Estes são seus links pessoais para cadastro de alunos. 
            Cada matrícula realizada através destes links será automaticamente vinculada a você.
        </div>

        <!-- Link para Alunos Regulares -->
        <div class="mb-4">
            <div class="card border-primary">
                <div class="card-header bg-primary text-white">
                    <h6 class="mb-0">
                        <i class="fas fa-user me-2"></i>Link para Alunos Regulares
                    </h6>
                </div>
                <div class="card-body">
                    <div class="input-group mb-2">
                        <input type="text" class="form-control" id="linkRegular" value="<?php echo $link_regular; ?>" readonly>
                        <button class="btn btn-primary" type="button" onclick="copiarLink('linkRegular', 'primary')">
                            <i class="fas fa-copy"></i> Copiar Link
                        </button>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-dollar-sign me-1"></i>
                        Use este link para alunos que pagarão o valor integral do curso.
                    </small>
                </div>
            </div>
        </div>

        <!-- Link para Alunos Bolsistas -->
        <div class="mb-4">
            <div class="card border-success">
                <div class="card-header bg-success text-white">
                    <h6 class="mb-0">
                        <i class="fas fa-graduation-cap me-2"></i>Link para Alunos Bolsistas
                    </h6>
                </div>
                <div class="card-body">
                    <div class="input-group mb-2">
                        <input type="text" class="form-control" id="linkBolsista" value="<?php echo $link_bolsista; ?>" readonly>
                        <button class="btn btn-success" type="button" onclick="copiarLink('linkBolsista', 'success')">
                            <i class="fas fa-copy"></i> Copiar Link
                        </button>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-percentage me-1"></i>
                        Use este link para alunos que receberão desconto ou bolsa de estudos.
                    </small>
                </div>
            </div>
        </div>

        <!-- Instruções de uso -->
        <div class="alert alert-warning">
            <h6><i class="fas fa-exclamation-triangle me-2"></i>Importante:</h6>
            <ul class="mb-0">
                <li>Estes links são únicos e pessoais para você</li>
                <li>Todas as matrículas realizadas através destes links serão contabilizadas em seu nome</li>
                <li>Use o link correto baseado no tipo de aluno que você está atendendo</li>
                <li>Não compartilhe estes links com outros especialistas</li>
            </ul>
        </div>

        <div class="mt-4">
            <h6><i class="fas fa-question-circle me-2"></i>Como usar:</h6>
            <ol>
                <li><strong>Escolha o link apropriado</strong> baseado no tipo de aluno (Regular ou Bolsista)</li>
                <li><strong>Copie o link</strong> clicando no botão "Copiar Link"</li>
                <li><strong>Envie o link</strong> para seu aluno através de e-mail, WhatsApp ou outra forma de comunicação</li>
                <li><strong>O aluno se cadastra</strong> através do link e é automaticamente vinculado a você</li>
                <li><strong>A matrícula é contabilizada</strong> quando o aluno: preencher o cadastro + aceitar o contrato + investir R$ 660,00 ou mais</li>
            </ol>
        </div>

        <!-- Estatísticas separadas por tipo -->
        <?php
        // Contar alunos regulares deste especialista
        $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM alunos WHERE especialista_id = ? AND tipo_contrato = 'regular'");
        $stmt->execute([$especialista_id]);
        $total_regular = $stmt->fetch()['total'];
        
        // Contar alunos bolsistas deste especialista
        $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM alunos WHERE especialista_id = ? AND tipo_contrato = 'bolsista'");
        $stmt->execute([$especialista_id]);
        $total_bolsista = $stmt->fetch()['total'];
        
        $total_geral = $total_regular + $total_bolsista;
        
        // Contar matrículas efetivadas
        $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM matriculas WHERE especialista_id = ? AND matricula_contabilizada = TRUE");
        $stmt->execute([$especialista_id]);
        $total_matriculas_efetivadas = $stmt->fetch()['total'];
        
        // Contar alunos cadastrados nos últimos 30 dias
        $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM alunos WHERE especialista_id = ? AND data_cadastro >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
        $stmt->execute([$especialista_id]);
        $alunos_30_dias = $stmt->fetch()['total'];
        ?>

        <div class="row mt-4">
            <div class="col-md-3">
                <div class="custom-card bg-primary text-white">
                    <div class="card-body text-center">
                        <h3><?php echo $total_regular; ?></h3>
                        <p class="mb-0">Alunos Regulares</p>
                        <small>Cadastrados</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="custom-card bg-success text-white">
                    <div class="card-body text-center">
                        <h3><?php echo $total_bolsista; ?></h3>
                        <p class="mb-0">Alunos Bolsistas</p>
                        <small>Cadastrados</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="custom-card bg-info text-white">
                    <div class="card-body text-center">
                        <h3><?php echo $total_matriculas_efetivadas; ?></h3>
                        <p class="mb-0">Matrículas</p>
                        <small>Efetivadas (R$ 660+)</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="custom-card bg-warning text-white">
                    <div class="card-body text-center">
                        <h3><?php echo $alunos_30_dias; ?></h3>
                        <p class="mb-0">Últimos 30 dias</p>
                        <small>Novos cadastros</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Histórico de cadastros recentes -->
        <?php
        $stmt = $pdo->prepare("
            SELECT a.nome, a.email, a.tipo_contrato, a.data_cadastro,
                   m.matricula_contabilizada, m.valor_investido, m.data_matricula_efetivada
            FROM alunos a
            LEFT JOIN matriculas m ON a.id = m.aluno_id
            WHERE a.especialista_id = ? 
            ORDER BY a.data_cadastro DESC 
            LIMIT 10
        ");
        $stmt->execute([$especialista_id]);
        $alunos_recentes = $stmt->fetchAll();
        ?>

        <?php if ($alunos_recentes): ?>
        <div class="mt-4">
            <h6><i class="fas fa-history me-2"></i>Cadastros Recentes:</h6>
            <div class="table-responsive">
                <table class="table table-sm table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Email</th>
                            <th>Tipo</th>
                            <th>Data Cadastro</th>
                            <th>Status Matrícula</th>
                            <th>Valor Investido</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($alunos_recentes as $aluno): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($aluno['nome']); ?></td>
                            <td><?php echo htmlspecialchars($aluno['email']); ?></td>
                            <td>
                                <span class="badge <?php echo $aluno['tipo_contrato'] === 'bolsista' ? 'bg-success' : 'bg-primary'; ?>">
                                    <?php echo $aluno['tipo_contrato'] === 'bolsista' ? 'Bolsista' : 'Regular'; ?>
                                </span>
                            </td>
                            <td><?php echo date('d/m/Y H:i', strtotime($aluno['data_cadastro'])); ?></td>
                            <td>
                                <?php if ($aluno['matricula_contabilizada']): ?>
                                    <span class="badge bg-success">
                                        <i class="fas fa-check-circle"></i> Efetivada
                                    </span>
                                    <br>
                                    <small><?php echo date('d/m/Y', strtotime($aluno['data_matricula_efetivada'])); ?></small>
                                <?php else: ?>
                                    <span class="badge bg-warning text-dark">
                                        <i class="fas fa-clock"></i> Pendente
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong>R$ <?php echo number_format($aluno['valor_investido'] ?? 0, 2, ',', '.'); ?></strong>
                                <?php if (!$aluno['matricula_contabilizada'] && $aluno['valor_investido'] < 660): ?>
                                    <br>
                                    <small class="text-muted">
                                        Faltam R$ <?php echo number_format(660 - $aluno['valor_investido'], 2, ',', '.'); ?>
                                    </small>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function copiarLink(inputId, btnType) {
    var copyText = document.getElementById(inputId);
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    
    // Usar API moderna de clipboard se disponível
    if (navigator.clipboard) {
        navigator.clipboard.writeText(copyText.value).then(function() {
            mostrarFeedback(inputId, btnType);
        }, function() {
            // Fallback para método antigo
            document.execCommand("copy");
            mostrarFeedback(inputId, btnType);
        });
    } else {
        document.execCommand("copy");
        mostrarFeedback(inputId, btnType);
    }
}

function mostrarFeedback(inputId, btnType) {
    var btn = document.getElementById(inputId).nextElementSibling;
    var originalText = btn.innerHTML;
    var originalClass = 'btn-' + btnType;
    
    btn.innerHTML = '<i class="fas fa-check"></i> Copiado!';
    btn.classList.remove(originalClass);
    btn.classList.add('btn-success');
    
    setTimeout(function() {
        btn.innerHTML = originalText;
        btn.classList.remove('btn-success');
        btn.classList.add(originalClass);
    }, 2000);
}
</script>

<style>
.custom-card {
    transition: all 0.3s ease;
}

.custom-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.table-hover tbody tr:hover {
    background-color: rgba(0,0,0,0.02);
}

.badge {
    font-size: 0.85em;
}
</style>
