<?php
require_once '../includes/config.php';

$especialista_id = $_SESSION['especialista_id'];

// Buscar dados do especialista
$stmt = $pdo->prepare("SELECT * FROM especialistas WHERE id = ?");
$stmt->execute([$especialista_id]);
$especialista = $stmt->fetch();

$message = '';
$error = '';

// Processar formulário de atualização de dados
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] == 'update_profile') {
            // Atualizar dados do perfil
            $nome = trim($_POST['nome']);
            $telefone = trim($_POST['telefone']);
            
            if ($nome) {
                try {
                    $stmt = $pdo->prepare("UPDATE especialistas SET nome = ?, telefone = ? WHERE id = ?");
                    $stmt->execute([$nome, $telefone, $especialista_id]);
                    $message = "Perfil atualizado com sucesso!";
                    
                    // Recarregar dados
                    $stmt = $pdo->prepare("SELECT * FROM especialistas WHERE id = ?");
                    $stmt->execute([$especialista_id]);
                    $especialista = $stmt->fetch();
                } catch (Exception $e) {
                    $error = "Erro ao atualizar perfil: " . $e->getMessage();
                }
            } else {
                $error = "Nome é obrigatório.";
            }
        } elseif ($_POST['action'] == 'change_password') {
            // Alterar senha
            $senha_atual = $_POST['senha_atual'];
            $nova_senha = $_POST['nova_senha'];
            $confirmar_senha = $_POST['confirmar_senha'];
            
            if ($senha_atual && $nova_senha && $confirmar_senha) {
                // Verificar senha atual
                if (password_verify($senha_atual, $especialista['senha'])) {
                    if ($nova_senha === $confirmar_senha) {
                        if (strlen($nova_senha) >= 6) {
                            try {
                                $senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);
                                $stmt = $pdo->prepare("UPDATE especialistas SET senha = ? WHERE id = ?");
                                $stmt->execute([$senha_hash, $especialista_id]);
                                $message = "Senha alterada com sucesso!";
                            } catch (Exception $e) {
                                $error = "Erro ao alterar senha: " . $e->getMessage();
                            }
                        } else {
                            $error = "A nova senha deve ter pelo menos 6 caracteres.";
                        }
                    } else {
                        $error = "A confirmação da senha não confere.";
                    }
                } else {
                    $error = "Senha atual incorreta.";
                }
            } else {
                $error = "Todos os campos de senha são obrigatórios.";
            }
        }
    }
}
?>

<div class="row">
    <div class="col-lg-8">
        <div class="custom-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-user-edit me-2"></i>Meu Perfil
                </h5>
            </div>
            <div class="card-body">
                <?php if ($message): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i><?php echo $message; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i><?php echo $error; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <input type="hidden" name="action" value="update_profile">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nome" class="form-label">Nome Completo</label>
                                <input type="text" class="form-control" id="nome" name="nome" 
                                       value="<?php echo htmlspecialchars($especialista['nome']); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" 
                                       value="<?php echo htmlspecialchars($especialista['email']); ?>" readonly>
                                <div class="form-text">O email não pode ser alterado</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="telefone" class="form-label">Telefone</label>
                        <input type="text" class="form-control" id="telefone" name="telefone" 
                               value="<?php echo htmlspecialchars($especialista['telefone']); ?>"
                               placeholder="(00) 00000-0000">
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Salvar Alterações
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="custom-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-key me-2"></i>Alterar Senha
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" id="formSenha">
                    <input type="hidden" name="action" value="change_password">
                    
                    <div class="mb-3">
                        <label for="senha_atual" class="form-label">Senha Atual</label>
                        <input type="password" class="form-control" id="senha_atual" name="senha_atual" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="nova_senha" class="form-label">Nova Senha</label>
                        <input type="password" class="form-control" id="nova_senha" name="nova_senha" 
                               minlength="6" required>
                        <div class="form-text">Mínimo de 6 caracteres</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="confirmar_senha" class="form-label">Confirmar Nova Senha</label>
                        <input type="password" class="form-control" id="confirmar_senha" name="confirmar_senha" 
                               minlength="6" required>
                    </div>
                    
                    <button type="submit" class="btn btn-secondary w-100">
                        <i class="fas fa-key me-2"></i>Alterar Senha
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Máscara para telefone
document.getElementById('telefone').addEventListener('input', function (e) {
    let value = e.target.value.replace(/\D/g, '');
    if (value.length <= 11) {
        value = value.replace(/(\d{2})(\d{5})(\d{4})/, '($1) $2-$3');
        if (value.length < 14) {
            value = value.replace(/(\d{2})(\d{4})(\d{4})/, '($1) $2-$3');
        }
    }
    e.target.value = value;
});

// Validação de confirmação de senha
document.getElementById('formSenha').addEventListener('submit', function(e) {
    const novaSenha = document.getElementById('nova_senha').value;
    const confirmarSenha = document.getElementById('confirmar_senha').value;
    
    if (novaSenha !== confirmarSenha) {
        e.preventDefault();
        alert('A confirmação da senha não confere com a nova senha.');
        return false;
    }
});
</script>
