@extends('layouts.admin')

@section('title', 'Editar Categoria')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.categorias.index') }}">Categorias</a></li>
            <li class="breadcrumb-item active">Editar</li>
        </ol>
    </nav>
    <h1 class="content-title">Editar Categoria</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.categorias.update', $categoria->id) }}">
            @csrf
            @method('PUT')

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="nome" class="form-label">Nome *</label>
                    <input type="text" class="form-control" id="nome" name="nome" 
                           value="{{ old('nome', $categoria->nome) }}" required>
                </div>
                <div class="col-md-6">
                    <label for="slug" class="form-label">Slug *</label>
                    <input type="text" class="form-control" id="slug" name="slug" 
                           value="{{ old('slug', $categoria->slug) }}" required>
                </div>
            </div>

            <div class="mb-3">
                <label for="descricao" class="form-label">Descrição</label>
                <textarea class="form-control" id="descricao" name="descricao" rows="3">{{ old('descricao', $categoria->descricao) }}</textarea>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="nivel_acesso" class="form-label">Nível de Acesso *</label>
                    <input type="number" class="form-control" id="nivel_acesso" name="nivel_acesso" 
                           value="{{ old('nivel_acesso', $categoria->nivel_acesso) }}" min="1" max="1000" required>
                </div>
                <div class="col-md-6">
                    <label for="ativo" class="form-label">Status *</label>
                    <select class="form-select" id="ativo" name="ativo" required>
                        <option value="1" {{ old('ativo', $categoria->ativo) == 1 ? 'selected' : '' }}>Ativo</option>
                        <option value="0" {{ old('ativo', $categoria->ativo) == 0 ? 'selected' : '' }}>Inativo</option>
                    </select>
                </div>
            </div>

            <div class="text-end">
                <a href="{{ route('admin.categorias.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Alterações
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

