@extends('layouts.admin')

@section('title', 'Categorias')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Categorias de Usuário</h1>
        <p class="content-subtitle">Gerenciamento de categorias e permissões</p>
    </div>
    <a href="{{ route('admin.categorias.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Nova Categoria
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nome</th>
                        <th>Slug</th>
                        <th>Descrição</th>
                        <th>Nível Acesso</th>
                        <th>Status</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($categorias as $categoria)
                    <tr>
                        <td><strong>#{{ $categoria->id }}</strong></td>
                        <td><strong>{{ $categoria->nome }}</strong></td>
                        <td><code>{{ $categoria->slug }}</code></td>
                        <td>{{ $categoria->descricao ?? '-' }}</td>
                        <td>
                            <span class="badge bg-info">{{ $categoria->nivel_acesso }}</span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $categoria->ativo ? 'success' : 'secondary' }}">
                                {{ $categoria->ativo ? 'Ativo' : 'Inativo' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.categorias.edit', $categoria->id) }}" class="btn btn-outline-primary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="btn btn-outline-{{ $categoria->ativo ? 'warning' : 'success' }}" 
                                        onclick="toggleStatus({{ $categoria->id }})" 
                                        title="{{ $categoria->ativo ? 'Desativar' : 'Ativar' }}">
                                    <i class="fas fa-{{ $categoria->ativo ? 'toggle-on' : 'toggle-off' }}"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma categoria encontrada</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleStatus(id) {
    fetch(`/equipe/public/admin/categorias/${id}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        alert('Erro ao atualizar status');
        console.error(error);
    });
}
</script>
@endpush

