@extends('layouts.admin')

@section('title', 'Nova Comissão')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.comissoes.index') }}">Comissões</a></li>
            <li class="breadcrumb-item active">Nova</li>
        </ol>
    </nav>
    <h1 class="content-title">Nova Comissão</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.comissoes.store') }}" id="formComissao">
            @csrf

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="negociacao_id" class="form-label">Negociação *</label>
                    <select class="form-select @error('negociacao_id') is-invalid @enderror" id="negociacao_id" name="negociacao_id" required>
                        <option value="">Selecione uma negociação...</option>
                        @foreach($negociacoes as $negociacao)
                            <option value="{{ $negociacao->id }}" 
                                    data-valor="{{ $negociacao->valor_total }}"
                                    data-especialista="{{ $negociacao->especialista_id }}">
                                #{{ $negociacao->id }} - {{ $negociacao->lead_nome }} - R$ {{ number_format($negociacao->valor_total, 2, ',', '.') }}
                            </option>
                        @endforeach
                    </select>
                    @error('negociacao_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Apenas negociações fechadas sem comissão cadastrada</small>
                </div>
                <div class="col-md-6">
                    <label for="especialista_id" class="form-label">Especialista *</label>
                    <select class="form-select @error('especialista_id') is-invalid @enderror" id="especialista_id" name="especialista_id" required>
                        <option value="">Selecione um especialista...</option>
                        @foreach($especialistas as $especialista)
                            <option value="{{ $especialista->id }}">{{ $especialista->nome }}</option>
                        @endforeach
                    </select>
                    @error('especialista_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="percentual" class="form-label">Percentual (%) *</label>
                    <input type="number" step="0.01" min="0" max="100" class="form-control @error('percentual') is-invalid @enderror" 
                           id="percentual" name="percentual" value="{{ old('percentual') }}" required>
                    @error('percentual')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4">
                    <label for="valor" class="form-label">Valor da Comissão (R$) *</label>
                    <input type="number" step="0.01" min="0" class="form-control @error('valor') is-invalid @enderror" 
                           id="valor" name="valor" value="{{ old('valor') }}" required>
                    @error('valor')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <button type="button" class="btn btn-sm btn-outline-primary mt-2" onclick="calcularComissao()">
                        <i class="fas fa-calculator me-1"></i>Calcular Automaticamente
                    </button>
                </div>
                <div class="col-md-4">
                    <label for="data_prevista" class="form-label">Data Prevista para Pagamento *</label>
                    <input type="date" class="form-control @error('data_prevista') is-invalid @enderror" 
                           id="data_prevista" name="data_prevista" value="{{ old('data_prevista', date('Y-m-d')) }}" required>
                    @error('data_prevista')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="mb-3">
                <label for="status" class="form-label">Status *</label>
                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                    <option value="pendente" {{ old('status') === 'pendente' ? 'selected' : '' }}>Pendente</option>
                    <option value="liberada" {{ old('status') === 'liberada' ? 'selected' : '' }}>Liberada</option>
                    <option value="paga" {{ old('status') === 'paga' ? 'selected' : '' }}>Paga</option>
                </select>
                @error('status')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="text-end">
                <a href="{{ route('admin.comissoes.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Criar Comissão
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Auto-selecionar especialista quando selecionar negociação
document.getElementById('negociacao_id').addEventListener('change', function() {
    const option = this.options[this.selectedIndex];
    const especialistaId = option.getAttribute('data-especialista');
    if (especialistaId) {
        document.getElementById('especialista_id').value = especialistaId;
    }
});

// Calcular comissão automaticamente
function calcularComissao() {
    const negociacaoId = document.getElementById('negociacao_id').value;
    const percentual = document.getElementById('percentual').value;

    if (!negociacaoId) {
        alert('Selecione uma negociação primeiro.');
        return;
    }

    if (!percentual || percentual <= 0) {
        alert('Informe o percentual da comissão.');
        return;
    }

    fetch('{{ route("admin.comissoes.calcular-comissao") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({
            negociacao_id: negociacaoId,
            percentual: percentual
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('valor').value = data.valor;
        } else {
            alert('Erro ao calcular comissão: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao calcular comissão');
    });
}

// Calcular automaticamente quando percentual mudar
document.getElementById('percentual').addEventListener('blur', function() {
    if (document.getElementById('negociacao_id').value && this.value) {
        calcularComissao();
    }
});
</script>
@endpush

