@extends('layouts.admin')

@section('title', 'Comissões')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Gerenciamento de Comissões</h1>
        <p class="content-subtitle">Gerencie as comissões dos especialistas</p>
    </div>
    <a href="{{ route('admin.comissoes.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Nova Comissão
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error') || $errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        {{ session('error') ?? $errors->first() }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-primary bg-opacity-10 rounded p-3">
                            <i class="fas fa-dollar-sign fa-2x text-primary"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ {{ number_format($stats['total'] ?? 0, 2, ',', '.') }}</div>
                        <small class="text-muted">Total de Comissões</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-warning bg-opacity-10 rounded p-3">
                            <i class="fas fa-clock fa-2x text-warning"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ {{ number_format($stats['pendentes'] ?? 0, 2, ',', '.') }}</div>
                        <small class="text-muted">Pendentes</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-info bg-opacity-10 rounded p-3">
                            <i class="fas fa-check-circle fa-2x text-info"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ {{ number_format($stats['liberadas'] ?? 0, 2, ',', '.') }}</div>
                        <small class="text-muted">Liberadas</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-success bg-opacity-10 rounded p-3">
                            <i class="fas fa-check-double fa-2x text-success"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ {{ number_format($stats['pagas'] ?? 0, 2, ',', '.') }}</div>
                        <small class="text-muted">Pagas</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.comissoes.index') }}" class="row g-3">
            <div class="col-md-3">
                <label for="especialista_id" class="form-label">Especialista</label>
                <select class="form-select" id="especialista_id" name="especialista_id">
                    <option value="">Todos</option>
                    @foreach($especialistas as $esp)
                        <option value="{{ $esp->id }}" {{ request('especialista_id') == $esp->id ? 'selected' : '' }}>
                            {{ $esp->nome }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                    <option value="">Todos</option>
                    <option value="pendente" {{ request('status') === 'pendente' ? 'selected' : '' }}>Pendente</option>
                    <option value="liberada" {{ request('status') === 'liberada' ? 'selected' : '' }}>Liberada</option>
                    <option value="paga" {{ request('status') === 'paga' ? 'selected' : '' }}>Paga</option>
                </select>
            </div>
            <div class="col-md-2">
                <label for="data_inicio" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="data_inicio" name="data_inicio" value="{{ request('data_inicio') }}">
            </div>
            <div class="col-md-2">
                <label for="data_fim" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="data_fim" name="data_fim" value="{{ request('data_fim') }}">
            </div>
            <div class="col-md-2">
                <label for="search" class="form-label">Buscar</label>
                <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Nome, ID...">
            </div>
            <div class="col-md-1 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Tabela -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Especialista</th>
                        <th>Lead</th>
                        <th>Negociação</th>
                        <th>Percentual</th>
                        <th>Valor</th>
                        <th>Status</th>
                        <th>Data Prevista</th>
                        <th width="150">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($comissoes as $comissao)
                    <tr>
                        <td><strong>#{{ $comissao->id }}</strong></td>
                        <td>
                            <div>
                                <strong>{{ $comissao->especialista_nome }}</strong>
                                <br>
                                <small class="text-muted">{{ $comissao->especialista_email }}</small>
                            </div>
                        </td>
                        <td>{{ $comissao->lead_nome ?? '-' }}</td>
                        <td>
                            <div>
                                <strong>R$ {{ number_format($comissao->negociacao_valor ?? 0, 2, ',', '.') }}</strong>
                                <br>
                                <small class="text-muted">ID: {{ $comissao->negociacao_id }}</small>
                            </div>
                        </td>
                        <td>{{ number_format($comissao->percentual, 2, ',', '.') }}%</td>
                        <td><strong class="text-success">R$ {{ number_format($comissao->valor, 2, ',', '.') }}</strong></td>
                        <td>
                            @php
                                $badges = [
                                    'pendente' => 'warning',
                                    'liberada' => 'info',
                                    'paga' => 'success',
                                ];
                                $badge = $badges[$comissao->status] ?? 'secondary';
                            @endphp
                            <span class="badge bg-{{ $badge }}" id="status-badge-{{ $comissao->id }}">
                                {{ ucfirst($comissao->status) }}
                            </span>
                        </td>
                        <td>
                            @if($comissao->data_prevista)
                                {{ \Carbon\Carbon::parse($comissao->data_prevista)->format('d/m/Y') }}
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.comissoes.show', $comissao->id) }}" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.comissoes.edit', $comissao->id) }}" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if($comissao->status !== 'paga')
                                <button type="button" class="btn btn-outline-success" onclick="atualizarStatus({{ $comissao->id }}, '{{ $comissao->status }}')" title="Atualizar Status">
                                    <i class="fas fa-sync"></i>
                                </button>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma comissão encontrada</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($comissoes->hasPages())
            <div class="mt-3">
                {{ $comissoes->links() }}
            </div>
        @endif
    </div>
</div>

<!-- Modal Atualizar Status -->
<div class="modal fade" id="modalStatus" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Atualizar Status da Comissão</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="comissao_id_status">
                <div class="mb-3">
                    <label for="novo_status" class="form-label">Novo Status</label>
                    <select class="form-select" id="novo_status">
                        <option value="pendente">Pendente</option>
                        <option value="liberada">Liberada</option>
                        <option value="paga">Paga</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarAtualizacaoStatus()">Atualizar</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function atualizarStatus(comissaoId, statusAtual) {
    document.getElementById('comissao_id_status').value = comissaoId;
    document.getElementById('novo_status').value = statusAtual === 'pendente' ? 'liberada' : 'paga';
    new bootstrap.Modal(document.getElementById('modalStatus')).show();
}

function confirmarAtualizacaoStatus() {
    const comissaoId = document.getElementById('comissao_id_status').value;
    const novoStatus = document.getElementById('novo_status').value;

    fetch(`{{ route('admin.comissoes.index') }}/${comissaoId}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ status: novoStatus })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert('Erro: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao atualizar status');
    });
}
</script>
@endpush

