@extends('layouts.admin')

@section('title', 'Editar Contrato')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.contratos.index') }}">Contratos</a></li>
            <li class="breadcrumb-item active">Editar</li>
        </ol>
    </nav>
    <h1 class="content-title">Editar Contrato</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.contratos.update', $contrato->id) }}">
            @csrf
            @method('PUT')

            <div class="alert alert-info">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Arquivo atual:</strong> {{ $contrato->arquivo }}
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="tipo" class="form-label">Tipo *</label>
                    <select class="form-select" id="tipo" name="tipo" required>
                        <option value="regular" {{ old('tipo', $contrato->tipo) === 'regular' ? 'selected' : '' }}>Regular</option>
                        <option value="bolsista" {{ old('tipo', $contrato->tipo) === 'bolsista' ? 'selected' : '' }}>Bolsista</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="ativo" class="form-label">Status *</label>
                    <select class="form-select" id="ativo" name="ativo" required>
                        <option value="1" {{ old('ativo', $contrato->ativo) == 1 ? 'selected' : '' }}>Ativo</option>
                        <option value="0" {{ old('ativo', $contrato->ativo) == 0 ? 'selected' : '' }}>Inativo</option>
                    </select>
                </div>
            </div>

            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Se ativar este contrato, os outros contratos do mesmo tipo serão desativados automaticamente.
            </div>

            <div class="text-end">
                <a href="{{ route('admin.contratos.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Alterações
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

