@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
<div class="content-header">
    <h1 class="content-title">Dashboard Administrativo</h1>
    <p class="content-subtitle">Visão consolidada do sistema de gestão de leads e vendas</p>
</div>

<!-- Filtro de Período -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.dashboard') }}" class="row g-3">
            <div class="col-md-4">
                <label for="start_date" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $start }}">
            </div>
            <div class="col-md-4">
                <label for="end_date" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $end }}">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- KPIs -->
<div class="stats-grid">
    <!-- Leads Captados -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($leadsAtual, 0, ',', '.') }}</div>
        <div class="stat-label">Leads Captados</div>
        <div class="mt-2">
            <small class="text-{{ $varLeadsMensal >= 0 ? 'success' : 'danger' }}">
                <i class="fas fa-{{ $varLeadsMensal >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                {{ number_format(abs($varLeadsMensal), 1) }}% vs mês anterior
            </small>
        </div>
    </div>

    <!-- Vendas Realizadas -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($vendasAtual, 0, ',', '.') }}</div>
        <div class="stat-label">Vendas Realizadas</div>
        <div class="mt-2">
            <small class="text-{{ $varVendasMensal >= 0 ? 'success' : 'danger' }}">
                <i class="fas fa-{{ $varVendasMensal >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                {{ number_format(abs($varVendasMensal), 1) }}% vs mês anterior
            </small>
        </div>
    </div>

    <!-- Receita -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ {{ number_format($receitaAtual, 2, ',', '.') }}</div>
        <div class="stat-label">Receita Total</div>
        <div class="mt-2">
            <small class="text-{{ $varReceitaMensal >= 0 ? 'success' : 'danger' }}">
                <i class="fas fa-{{ $varReceitaMensal >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                {{ number_format(abs($varReceitaMensal), 1) }}% vs mês anterior
            </small>
        </div>
    </div>

    <!-- Taxa de Conversão -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #e9d5ff; color: #a855f7;">
                <i class="fas fa-percentage"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($taxaConversaoAtual, 1) }}%</div>
        <div class="stat-label">Taxa de Conversão</div>
        <div class="mt-2">
            <small class="text-muted">
                Mês anterior: {{ number_format($taxaConversaoAnterior, 1) }}%
            </small>
        </div>
    </div>
</div>

<!-- Gráficos e Tabelas -->
<div class="row">
    <!-- Evolução Diária -->
    <div class="col-md-8 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Evolução Diária de Leads</h5>
            </div>
            <div class="card-body">
                <canvas id="chartEvolucao" height="80"></canvas>
            </div>
        </div>
    </div>

    <!-- Distribuição por Status -->
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Status dos Leads</h5>
            </div>
            <div class="card-body">
                <canvas id="chartStatus"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Top Especialistas -->
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Top 10 Especialistas</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Especialista</th>
                        <th>Leads Ativos</th>
                        <th>Vendas</th>
                        <th>Receita Gerada</th>
                        <th>Taxa de Conversão</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($especialistas as $esp)
                    <tr>
                        <td>{{ $esp->usuario->nome }}</td>
                        <td>{{ $esp->leads_ativos }}</td>
                        <td>{{ $esp->vendas_realizadas }}</td>
                        <td>R$ {{ number_format($esp->receita_gerada ?? 0, 2, ',', '.') }}</td>
                        <td>
                            @if($esp->leads_ativos > 0)
                                {{ number_format(($esp->vendas_realizadas / $esp->leads_ativos) * 100, 1) }}%
                            @else
                                0%
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted">Nenhum dado disponível</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Gráfico de Evolução Diária
    const ctxEvolucao = document.getElementById('chartEvolucao').getContext('2d');
    new Chart(ctxEvolucao, {
        type: 'line',
        data: {
            labels: {!! json_encode($evolucaoDiaria->pluck('data')->map(fn($d) => \Carbon\Carbon::parse($d)->format('d/m'))) !!},
            datasets: [{
                label: 'Leads',
                data: {!! json_encode($evolucaoDiaria->pluck('total')) !!},
                borderColor: '#3b82f6',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Gráfico de Status
    const ctxStatus = document.getElementById('chartStatus').getContext('2d');
    new Chart(ctxStatus, {
        type: 'doughnut',
        data: {
            labels: {!! json_encode($dadosStatus->pluck('status')) !!},
            datasets: [{
                data: {!! json_encode($dadosStatus->pluck('total')) !!},
                backgroundColor: [
                    '#3b82f6',
                    '#22c55e',
                    '#f59e0b',
                    '#ef4444',
                    '#8b5cf6'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true
        }
    });
</script>
@endpush

