@extends('layouts.admin')

@section('title', 'Detalhes da Equipe')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.equipes.index') }}">Equipes</a></li>
                <li class="breadcrumb-item active">{{ $equipe->nome }}</li>
            </ol>
        </nav>
        <h1 class="content-title">{{ $equipe->nome }}</h1>
    </div>
    <a href="{{ route('admin.equipes.edit', $equipe->id) }}" class="btn btn-primary">
        <i class="fas fa-edit me-2"></i>Editar
    </a>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Informações</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th>Coordenador:</th>
                        <td>{{ $equipe->coordenador?->nome ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Meta Mensal:</th>
                        <td>{{ $equipe->meta_mensal > 0 ? number_format($equipe->meta_mensal, 0) : '-' }}</td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <span class="badge bg-{{ $equipe->status === 'ativo' ? 'success' : 'secondary' }}">
                                {{ ucfirst($equipe->status) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Especialistas:</th>
                        <td><span class="badge bg-primary">{{ $especialistas->count() }}</span></td>
                    </tr>
                    <tr>
                        <th>Leads:</th>
                        <td><span class="badge bg-info">{{ $leads->count() }}</span></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="col-md-8 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Especialistas da Equipe</h5>
            </div>
            <div class="card-body">
                <div class="list-group">
                    @forelse($especialistas as $esp)
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ $esp->nome }}</strong>
                                    <small class="d-block text-muted">{{ $esp->email }}</small>
                                </div>
                                <small class="text-muted">
                                    Desde {{ \Carbon\Carbon::parse($esp->data_entrada)->format('d/m/Y') }}
                                </small>
                            </div>
                        </div>
                    @empty
                        <p class="text-muted text-center py-3">Nenhum especialista vinculado</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

