@extends('layouts.admin')

@section('title', 'Horários de Funcionamento')

@section('content')
<div class="content-header">
    <h1 class="content-title">Horários de Funcionamento</h1>
    <p class="content-subtitle">Configure os horários de atendimento</p>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="row">
    <!-- Horários Semanais -->
    <div class="col-md-8 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Horários da Semana</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('admin.horarios.update') }}">
                    @csrf
                    
                    @php
                        $diasSemana = [
                            0 => 'Domingo',
                            1 => 'Segunda-feira',
                            2 => 'Terça-feira',
                            3 => 'Quarta-feira',
                            4 => 'Quinta-feira',
                            5 => 'Sexta-feira',
                            6 => 'Sábado',
                        ];
                        $horariosIndexados = $horarios->keyBy('dia_semana');
                    @endphp

                    @foreach($diasSemana as $num => $dia)
                        @php
                            $horario = $horariosIndexados->get($num);
                        @endphp
                        <div class="row mb-3 align-items-center">
                            <div class="col-md-3">
                                <strong>{{ $dia }}</strong>
                                <input type="hidden" name="horarios[{{ $num }}][dia_semana]" value="{{ $num }}">
                            </div>
                            <div class="col-md-3">
                                <input type="time" class="form-control" name="horarios[{{ $num }}][hora_inicio]" 
                                       value="{{ $horario->hora_inicio ?? '08:00' }}" required>
                            </div>
                            <div class="col-md-3">
                                <input type="time" class="form-control" name="horarios[{{ $num }}][hora_fim]" 
                                       value="{{ $horario->hora_fim ?? '18:00' }}" required>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="horarios[{{ $num }}][ativo]">
                                    <option value="1" {{ ($horario->ativo ?? 1) ? 'selected' : '' }}>Ativo</option>
                                    <option value="0" {{ !($horario->ativo ?? 1) ? 'selected' : '' }}>Fechado</option>
                                </select>
                            </div>
                        </div>
                    @endforeach

                    <div class="text-end mt-4">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-save me-2"></i>Salvar Horários
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Exceções -->
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Exceções (Feriados)</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('admin.horarios.excecao') }}" class="mb-4">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Data</label>
                        <input type="date" class="form-control" name="data" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Motivo</label>
                        <input type="text" class="form-control" name="motivo" placeholder="Ex: Feriado Nacional" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tipo</label>
                        <select class="form-select" name="fechado">
                            <option value="1">Fechado</option>
                            <option value="0">Horário Especial</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-success w-100">
                        <i class="fas fa-plus me-2"></i>Adicionar Exceção
                    </button>
                </form>

                <hr>

                <div class="list-group">
                    @forelse($excecoes as $excecao)
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <strong>{{ \Carbon\Carbon::parse($excecao->data)->format('d/m/Y') }}</strong>
                                <small class="d-block text-muted">{{ $excecao->motivo }}</small>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="excluirExcecao({{ $excecao->id }})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    @empty
                        <p class="text-muted text-center">Nenhuma exceção cadastrada</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function excluirExcecao(id) {
    if (!confirm('Deseja excluir esta exceção?')) return;

    fetch(`/equipe/public/admin/horarios/excecao/${id}`, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
@endpush

