@extends('layouts.admin')

@section('title', 'Marketing')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Marketing</h1>
        <p class="content-subtitle">Gestão de links e campanhas de marketing</p>
    </div>
    <a href="{{ route('admin.marketing.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Novo Link
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Link Encurtado</th>
                        <th>UTM Source</th>
                        <th>UTM Campaign</th>
                        <th>Clicks</th>
                        <th>Status</th>
                        <th width="150">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($links as $link)
                    <tr>
                        <td>
                            <strong>{{ $link->nome }}</strong>
                            <br>
                            <small class="text-muted">{{ \Carbon\Carbon::parse($link->data_criacao)->format('d/m/Y H:i') }}</small>
                        </td>
                        <td>
                            <div class="input-group input-group-sm">
                                <input type="text" 
                                       class="form-control form-control-sm" 
                                       value="{{ url('/l/' . $link->codigo) }}" 
                                       id="link-{{ $link->id }}" 
                                       readonly>
                                <button class="btn btn-outline-secondary" 
                                        type="button" 
                                        onclick="copiarLink('link-{{ $link->id }}')"
                                        title="Copiar link">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </td>
                        <td>
                            @php
                                // Extrair UTM da URL ou descrição
                                $utmSource = '-';
                                if ($link->descricao && preg_match('/source=([^,]+)/', $link->descricao, $matches)) {
                                    $utmSource = $matches[1];
                                }
                            @endphp
                            <span class="badge bg-info">{{ $utmSource }}</span>
                        </td>
                        <td>
                            @php
                                $utmCampaign = '-';
                                if ($link->descricao && preg_match('/campaign=([^,]+)/', $link->descricao, $matches)) {
                                    $utmCampaign = $matches[1];
                                }
                            @endphp
                            <span class="badge bg-secondary">{{ $utmCampaign }}</span>
                        </td>
                        <td>
                            <span class="badge bg-primary fs-6">{{ $clicks[$link->id] ?? 0 }}</span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $link->ativo ? 'success' : 'secondary' }}">
                                {{ $link->ativo ? 'Ativo' : 'Inativo' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.marketing.show', $link->id) }}" class="btn btn-outline-primary" title="Estatísticas">
                                    <i class="fas fa-chart-line"></i>
                                </a>
                                <button type="button" class="btn btn-outline-{{ $link->ativo ? 'warning' : 'success' }}" 
                                        onclick="toggleStatus({{ $link->id }})" 
                                        title="{{ $link->ativo ? 'Desativar' : 'Ativar' }}">
                                    <i class="fas fa-{{ $link->ativo ? 'toggle-on' : 'toggle-off' }}"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhum link de marketing encontrado</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($links->hasPages())
            <div class="mt-3">
                {{ $links->links() }}
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleStatus(id) {
    fetch(`/equipe/public/admin/marketing/${id}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function copiarLink(inputId) {
    const input = document.getElementById(inputId);
    input.select();
    input.setSelectionRange(0, 99999); // Para mobile
    
    navigator.clipboard.writeText(input.value).then(() => {
        // Mostrar feedback
        const btn = event.target.closest('button');
        const icon = btn.querySelector('i');
        icon.className = 'fas fa-check';
        btn.classList.remove('btn-outline-secondary');
        btn.classList.add('btn-success');
        
        setTimeout(() => {
            icon.className = 'fas fa-copy';
            btn.classList.remove('btn-success');
            btn.classList.add('btn-outline-secondary');
        }, 2000);
    });
}
</script>
@endpush

