@extends('layouts.admin')

@section('title', 'Relatórios')

@section('content')
<div class="content-header">
    <h1 class="content-title">Relatórios</h1>
    <p class="content-subtitle">Relatórios gerenciais e análises</p>
</div>

<div class="row">
    <!-- Relatório de Vendas -->
    <div class="col-md-4 mb-4">
        <div class="card h-100">
            <div class="card-body text-center">
                <div class="mb-3">
                    <i class="fas fa-chart-line fa-3x text-primary"></i>
                </div>
                <h5>Relatório de Vendas</h5>
                <p class="text-muted">Análise detalhada de vendas por período, especialista e equipe</p>
                <a href="{{ route('admin.relatorios.vendas') }}" class="btn btn-primary">
                    <i class="fas fa-eye me-2"></i>Visualizar
                </a>
            </div>
        </div>
    </div>

    <!-- Relatório de Performance -->
    <div class="col-md-4 mb-4">
        <div class="card h-100">
            <div class="card-body text-center">
                <div class="mb-3">
                    <i class="fas fa-trophy fa-3x text-warning"></i>
                </div>
                <h5>Performance de Especialistas</h5>
                <p class="text-muted">Ranking e análise de performance individual</p>
                <a href="{{ route('admin.relatorios.performance') }}" class="btn btn-warning">
                    <i class="fas fa-eye me-2"></i>Visualizar
                </a>
            </div>
        </div>
    </div>

    <!-- Funil de Vendas -->
    <div class="col-md-4 mb-4">
        <div class="card h-100">
            <div class="card-body text-center">
                <div class="mb-3">
                    <i class="fas fa-filter fa-3x text-success"></i>
                </div>
                <h5>Funil de Vendas</h5>
                <p class="text-muted">Análise do funil de conversão e motivos de perda</p>
                <a href="{{ route('admin.relatorios.funil') }}" class="btn btn-success">
                    <i class="fas fa-eye me-2"></i>Visualizar
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

