@extends('layouts.admin')

@section('title', 'Detalhes do Usuário')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.usuarios.index') }}">Usuários</a></li>
                <li class="breadcrumb-item active">{{ $usuario->nome }}</li>
            </ol>
        </nav>
        <h1 class="content-title">{{ $usuario->nome }}</h1>
    </div>
    <a href="{{ route('admin.usuarios.edit', $usuario->id) }}" class="btn btn-primary">
        <i class="fas fa-edit me-2"></i>Editar
    </a>
</div>

<div class="card">
    <div class="card-body">
        <table class="table table-borderless">
            <tr>
                <th width="200">Nome:</th>
                <td>{{ $usuario->nome }}</td>
            </tr>
            <tr>
                <th>Email:</th>
                <td>{{ $usuario->email }}</td>
            </tr>
            <tr>
                <th>Telefone:</th>
                <td>{{ $usuario->telefone ?? '-' }}</td>
            </tr>
            <tr>
                <th>Categoria:</th>
                <td>
                    @if($categoria)
                        @php
                            $badges = [
                                'admin' => 'danger',
                                'especialista' => 'primary',
                                'coordenador' => 'info',
                                'secretaria' => 'warning',
                                'professor' => 'success',
                                'aluno' => 'secondary',
                                'gestao_pedagogica' => 'purple',
                                'marketing' => 'pink',
                            ];
                            $badge = $badges[$categoria->slug] ?? 'secondary';
                        @endphp
                        <span class="badge bg-{{ $badge }}">{{ $categoria->nome }}</span>
                        @if($categoria->descricao)
                            <br><small class="text-muted">{{ $categoria->descricao }}</small>
                        @endif
                    @else
                        <span class="badge bg-secondary">Sem categoria</span>
                    @endif
                </td>
            </tr>
            <tr>
                <th>Status:</th>
                <td>
                    <span class="badge bg-{{ $usuario->status === 'ativo' ? 'success' : 'secondary' }}">
                        {{ ucfirst($usuario->status) }}
                    </span>
                </td>
            </tr>
            <tr>
                <th>Data Cadastro:</th>
                <td>{{ $usuario->data_cadastro ? \Carbon\Carbon::parse($usuario->data_cadastro)->format('d/m/Y H:i') : '-' }}</td>
            </tr>
            <tr>
                <th>Último Login:</th>
                <td>{{ $usuario->ultimo_login ? \Carbon\Carbon::parse($usuario->ultimo_login)->format('d/m/Y H:i') : 'Nunca' }}</td>
            </tr>
        </table>
    </div>
</div>
@endsection

