@extends('layouts.admin')

@section('title', 'Novo Valor de Curso')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.valores-curso.index') }}">Valores</a></li>
            <li class="breadcrumb-item active">Novo</li>
        </ol>
    </nav>
    <h1 class="content-title">Novo Valor de Curso</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.valores-curso.store') }}">
            @csrf

            <div class="mb-3">
                <label for="tipo" class="form-label">Tipo/Nome *</label>
                <input type="text" class="form-control" id="tipo" name="tipo" 
                       value="{{ old('tipo') }}" placeholder="Ex: Plano Básico, Plano Premium" required>
            </div>

            <div class="mb-3">
                <label for="descricao" class="form-label">Descrição</label>
                <textarea class="form-control" id="descricao" name="descricao" rows="3">{{ old('descricao') }}</textarea>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="valor" class="form-label">Valor (R$) *</label>
                    <input type="number" class="form-control" id="valor" name="valor" 
                           value="{{ old('valor') }}" min="0" step="0.01" required>
                </div>
                <div class="col-md-6">
                    <label for="ativo" class="form-label">Status *</label>
                    <select class="form-select" id="ativo" name="ativo" required>
                        <option value="1">Ativo</option>
                        <option value="0">Inativo</option>
                    </select>
                </div>
            </div>

            <div class="text-end">
                <a href="{{ route('admin.valores-curso.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Valor
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

