@extends('layouts.admin')

@section('title', 'Detalhes da Negociação')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.vendas.index') }}">Vendas</a></li>
            <li class="breadcrumb-item active">Negociação #{{ $venda->id }}</li>
        </ol>
    </nav>
    <h1 class="content-title">Negociação #{{ $venda->id }}</h1>
</div>

<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Informações da Negociação</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="150">Valor Total:</th>
                        <td><strong class="fs-4">R$ {{ number_format($venda->valor_total, 2, ',', '.') }}</strong></td>
                    </tr>
                    <tr>
                        <th>Entrada:</th>
                        <td>R$ {{ number_format($venda->valor_entrada ?? 0, 2, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <th>Parcelas:</th>
                        <td>{{ $venda->num_parcelas }}x de R$ {{ number_format($venda->valor_parcela ?? 0, 2, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <th>Forma Pagamento:</th>
                        <td>{{ ucfirst(str_replace('_', ' ', $venda->forma_pagamento)) }}</td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            @php
                                $statusBadges = [
                                    'pendente' => 'warning',
                                    'aprovada' => 'success',
                                    'finalizada' => 'success',
                                    'rejeitada' => 'danger',
                                ];
                                $badge = $statusBadges[$venda->status] ?? 'secondary';
                            @endphp
                            <span class="badge bg-{{ $badge }} fs-6">{{ ucfirst($venda->status) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Data Criação:</th>
                        <td>{{ \Carbon\Carbon::parse($venda->data_criacao)->format('d/m/Y H:i') }}</td>
                    </tr>
                    @if($venda->data_aprovacao)
                    <tr>
                        <th>Data Aprovação:</th>
                        <td>{{ \Carbon\Carbon::parse($venda->data_aprovacao)->format('d/m/Y H:i') }}</td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>
    </div>

    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Informações do Lead</h5>
            </div>
            <div class="card-body">
                @if($venda->lead)
                <table class="table table-borderless">
                    <tr>
                        <th width="150">Nome:</th>
                        <td>{{ $venda->lead->nome }}</td>
                    </tr>
                    <tr>
                        <th>Email:</th>
                        <td>{{ $venda->lead->email }}</td>
                    </tr>
                    <tr>
                        <th>Telefone:</th>
                        <td>{{ $venda->lead->telefone }}</td>
                    </tr>
                    <tr>
                        <th>Especialista:</th>
                        <td>{{ $especialista?->nome ?? '-' }}</td>
                    </tr>
                </table>
                <div class="text-end">
                    <a href="{{ route('admin.leads.show', $venda->lead->id) }}" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-eye me-2"></i>Ver Lead Completo
                    </a>
                </div>
                @else
                <p class="text-muted">Lead não encontrado</p>
                @endif
            </div>
        </div>
    </div>
</div>

@if($venda->observacoes)
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Observações</h5>
    </div>
    <div class="card-body">
        <p style="white-space: pre-wrap;">{{ $venda->observacoes }}</p>
    </div>
</div>
@endif
@endsection

