@extends('layouts.admin')

@section('title', 'Vouchers')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Vouchers</h1>
        <p class="content-subtitle">Gerenciamento de cupons de desconto</p>
    </div>
    <a href="{{ route('admin.vouchers.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Novo Voucher
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nome</th>
                        <th>Tipo</th>
                        <th>Desconto</th>
                        <th>Quantidade</th>
                        <th>Validade</th>
                        <th>Status</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($vouchers as $voucher)
                    <tr>
                        <td><code>{{ $voucher->codigo }}</code></td>
                        <td>{{ $voucher->nome ?? '-' }}</td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst($voucher->tipo) }}</span>
                        </td>
                        <td>
                            @if($voucher->percentual_desconto)
                                {{ $voucher->percentual_desconto }}%
                            @elseif($voucher->valor_desconto)
                                R$ {{ number_format($voucher->valor_desconto, 2, ',', '.') }}
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-secondary">
                                {{ $voucher->quantidade_usada }}/{{ $voucher->quantidade_total }}
                            </span>
                        </td>
                        <td>
                            {{ $voucher->validade ? \Carbon\Carbon::parse($voucher->validade)->format('d/m/Y') : 'Sem limite' }}
                        </td>
                        <td>
                            @php
                                $statusBadge = match($voucher->status) {
                                    'ativo' => 'success',
                                    'inativo' => 'secondary',
                                    'expirado' => 'danger',
                                    default => 'secondary',
                                };
                            @endphp
                            <span class="badge bg-{{ $statusBadge }}">{{ ucfirst($voucher->status) }}</span>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.vouchers.show', $voucher->id) }}" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.vouchers.edit', $voucher->id) }}" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="btn btn-outline-{{ $voucher->ativo ? 'warning' : 'success' }}" 
                                        onclick="toggleStatus({{ $voucher->id }})" 
                                        title="{{ $voucher->ativo ? 'Desativar' : 'Ativar' }}">
                                    <i class="fas fa-{{ $voucher->ativo ? 'toggle-on' : 'toggle-off' }}"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhum voucher encontrado</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($vouchers->hasPages())
            <div class="mt-3">
                {{ $vouchers->links() }}
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleStatus(id) {
    fetch(`/equipe/public/admin/vouchers/${id}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
@endpush

