@extends('layouts.coordenador')

@section('title', 'Feedback')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Sistema de Feedback</h1>
        <p class="content-subtitle">Registre observações sobre vendas e repasse informações ao administrativo</p>
    </div>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalFeedback">
        <i class="fas fa-plus me-2"></i>Novo Feedback
    </button>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error') || $errors->any())
    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        {{ session('error') ?? $errors->first() }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Estatísticas -->
<div class="stats-grid mb-4">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-comments"></i>
            </div>
        </div>
        <div class="stat-value">{{ $totalFeedbacks }}</div>
        <div class="stat-label">Total de Feedbacks</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-clock"></i>
            </div>
        </div>
        <div class="stat-value">{{ $feedbacksPendentes }}</div>
        <div class="stat-label">Pendentes</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-search"></i>
            </div>
        </div>
        <div class="stat-value">{{ $feedbacksEmAnalise }}</div>
        <div class="stat-label">Em Análise</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ $feedbacksResolvidos }}</div>
        <div class="stat-label">Resolvidos</div>
    </div>
</div>

<!-- Informações da Equipe -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <label class="form-label text-muted">Equipe</label>
                <input type="text" class="form-control" value="{{ $equipes->first()->nome ?? '-' }}" readonly>
            </div>
            <div class="col-md-4">
                <label class="form-label text-muted">Coordenador</label>
                <input type="text" class="form-control" value="{{ Auth::user()->nome }}" readonly>
            </div>
            <div class="col-md-4">
                <label class="form-label text-muted">Total de Especialistas</label>
                <input type="text" class="form-control" value="{{ $especialistas->count() }}" readonly>
            </div>
        </div>
    </div>
</div>

<!-- Lista de Feedbacks -->
<div class="card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Feedbacks Registrados</h5>
        <div class="col-md-4">
            <input type="text" class="form-control" id="searchFeedbacks" placeholder="Buscar feedback...">
        </div>
    </div>
    <div class="card-body">
        @if($feedbacks->isNotEmpty())
            <div class="table-container">
                <table class="table" id="tabelaFeedbacks">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th>Tipo</th>
                            <th>Categoria</th>
                            <th>Título</th>
                            <th>Responsável</th>
                            <th>Prioridade</th>
                            <th>Status</th>
                            <th width="120">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($feedbacks as $feedback)
                            <tr>
                                <td>{{ \Carbon\Carbon::parse($feedback->data_criacao)->format('d/m/Y H:i') }}</td>
                                <td>
                                    @php
                                        $tipos = [
                                            'venda' => 'Venda',
                                            'especialista' => 'Especialista',
                                            'equipe' => 'Equipe',
                                            'sistema' => 'Sistema',
                                            'outro' => 'Outro'
                                        ];
                                    @endphp
                                    {{ $tipos[$feedback->tipo] ?? $feedback->tipo }}
                                </td>
                                <td>
                                    @php
                                        $categorias = [
                                            'melhoria' => 'Melhoria',
                                            'problema' => 'Problema',
                                            'sugestao' => 'Sugestão',
                                            'elogio' => 'Elogio',
                                            'outro' => 'Outro'
                                        ];
                                    @endphp
                                    {{ $categorias[$feedback->categoria] ?? $feedback->categoria }}
                                </td>
                                <td>
                                    <strong>{{ $feedback->titulo }}</strong><br>
                                    <small class="text-muted">{{ Str::limit($feedback->descricao, 100) }}...</small>
                                </td>
                                <td>
                                    @if($feedback->especialista_id)
                                        <span class="badge badge-info">{{ $feedback->especialista_nome }}</span>
                                    @else
                                        <span class="badge badge-secondary">Geral</span>
                                    @endif
                                </td>
                                <td>
                                    @php
                                        $prioridades = [
                                            'baixa' => ['label' => 'Baixa', 'cor' => 'badge-secondary'],
                                            'media' => ['label' => 'Média', 'cor' => 'badge-info'],
                                            'alta' => ['label' => 'Alta', 'cor' => 'badge-warning'],
                                            'urgente' => ['label' => 'Urgente', 'cor' => 'badge-danger']
                                        ];
                                        $prioridade = $prioridades[$feedback->prioridade] ?? ['label' => $feedback->prioridade, 'cor' => 'badge-secondary'];
                                    @endphp
                                    <span class="badge {{ $prioridade['cor'] }}">{{ $prioridade['label'] }}</span>
                                </td>
                                <td>
                                    @php
                                        $status_cores = [
                                            'pendente' => 'badge-warning',
                                            'em_analise' => 'badge-info',
                                            'resolvido' => 'badge-success',
                                            'fechado' => 'badge-secondary'
                                        ];
                                    @endphp
                                    <span class="badge {{ $status_cores[$feedback->status] ?? 'badge-secondary' }}">
                                        {{ ucfirst(str_replace('_', ' ', $feedback->status)) }}
                                    </span>
                                </td>
                                <td>
                                    @if($feedback->status !== 'resolvido' && $feedback->status !== 'fechado')
                                        <button class="btn btn-sm btn-primary" onclick="atualizarStatusFeedback({{ $feedback->id }}, '{{ $feedback->status }}')">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-comments fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum feedback registrado</h5>
                <p class="text-muted">Comece a registrar feedbacks sobre vendas, especialistas e equipe.</p>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalFeedback">
                    <i class="fas fa-plus me-2"></i>Criar Primeiro Feedback
                </button>
            </div>
        @endif
    </div>
</div>

<!-- Modal Criar Feedback -->
<div class="modal fade" id="modalFeedback" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Criar Novo Feedback</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('coordenador.feedback.store') }}">
                @csrf
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Tipo *</label>
                            <select name="tipo" class="form-select" required>
                                <option value="">Selecione o tipo...</option>
                                <option value="venda">Venda</option>
                                <option value="especialista">Especialista</option>
                                <option value="equipe">Equipe</option>
                                <option value="sistema">Sistema</option>
                                <option value="outro">Outro</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Categoria *</label>
                            <select name="categoria" class="form-select" required>
                                <option value="">Selecione a categoria...</option>
                                <option value="melhoria">Melhoria</option>
                                <option value="problema">Problema</option>
                                <option value="sugestao">Sugestão</option>
                                <option value="elogio">Elogio</option>
                                <option value="outro">Outro</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Título *</label>
                            <input type="text" name="titulo" class="form-control" required placeholder="Título resumido do feedback">
                        </div>
                        <div class="col-12">
                            <label class="form-label">Descrição *</label>
                            <textarea name="descricao" class="form-control" rows="4" required placeholder="Descreva detalhadamente o feedback..."></textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Prioridade *</label>
                            <select name="prioridade" class="form-select" required>
                                <option value="">Selecione a prioridade...</option>
                                <option value="baixa">Baixa</option>
                                <option value="media">Média</option>
                                <option value="alta">Alta</option>
                                <option value="urgente">Urgente</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Especialista (opcional)</label>
                            <select name="especialista_id" class="form-select">
                                <option value="">Geral (não específico)</option>
                                @foreach($especialistas as $esp)
                                    <option value="{{ $esp->id }}">{{ $esp->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Salvar Feedback
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Atualizar Status -->
<div class="modal fade" id="modalStatus" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Atualizar Status do Feedback</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('coordenador.feedback.update-status') }}">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="feedback_id" id="feedback_id_status">
                    
                    <div class="mb-3">
                        <label class="form-label">Novo Status *</label>
                        <select name="novo_status" class="form-select" required>
                            <option value="">Selecione o novo status...</option>
                            <option value="pendente">Pendente</option>
                            <option value="em_analise">Em Análise</option>
                            <option value="resolvido">Resolvido</option>
                            <option value="fechado">Fechado</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Observação (opcional)</label>
                        <textarea name="observacao" class="form-control" rows="3" placeholder="Adicione uma observação sobre a mudança de status..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Atualizar Status
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Busca em tempo real
document.getElementById('searchFeedbacks')?.addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll('#tabelaFeedbacks tbody tr');
    
    rows.forEach(row => {
        const titulo = row.cells[3].textContent.toLowerCase();
        const tipo = row.cells[1].textContent.toLowerCase();
        const categoria = row.cells[2].textContent.toLowerCase();
        
        if (titulo.includes(searchTerm) || tipo.includes(searchTerm) || categoria.includes(searchTerm)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});

function atualizarStatusFeedback(feedbackId, statusAtual) {
    document.getElementById('feedback_id_status').value = feedbackId;
    
    // Definir próximo status sugerido
    let proximoStatus = 'em_analise';
    if (statusAtual === 'em_analise') proximoStatus = 'resolvido';
    else if (statusAtual === 'resolvido') proximoStatus = 'fechado';
    
    // Selecionar o próximo status no modal
    setTimeout(() => {
        const select = document.querySelector('#modalStatus select[name="novo_status"]');
        if (select) {
            select.value = proximoStatus;
        }
    }, 100);
    
    new bootstrap.Modal(document.getElementById('modalStatus')).show();
}
</script>
@endpush


