@extends('layouts.coordenador')

@section('title', 'Vendas')

@section('content')
<div class="content-header">
    <h1 class="content-title">Acompanhamento de Vendas</h1>
    <p class="content-subtitle">Monitore o desempenho de vendas da sua equipe de especialistas</p>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('coordenador.vendas.index') }}" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Mês</label>
                <select name="mes" class="form-select">
                    @for($i = 1; $i <= 12; $i++)
                        <option value="{{ str_pad($i, 2, '0', STR_PAD_LEFT) }}" {{ $mes == str_pad($i, 2, '0', STR_PAD_LEFT) ? 'selected' : '' }}>
                            {{ \Carbon\Carbon::create(null, $i, 1)->locale('pt_BR')->translatedFormat('F') }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Ano</label>
                <select name="ano" class="form-select">
                    @for($i = date('Y'); $i >= date('Y') - 5; $i--)
                        <option value="{{ $i }}" {{ $ano == $i ? 'selected' : '' }}>{{ $i }}</option>
                    @endfor
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Especialista</label>
                <select name="especialista_id" class="form-select">
                    <option value="">Todos os especialistas</option>
                    @foreach($especialistas as $esp)
                        <option value="{{ $esp->id }}" {{ $especialistaId == $esp->id ? 'selected' : '' }}>
                            {{ $esp->nome }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-filter me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Estatísticas -->
<div class="stats-grid mb-4">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->vendas_mes ?? 0 }}</div>
        <div class="stat-label">Vendas {{ \Carbon\Carbon::create($ano, $mes, 1)->locale('pt_BR')->translatedFormat('F') }}</div>
        @if($variacao != 0)
            <small class="text-{{ $variacao > 0 ? 'success' : 'danger' }}">
                {{ $variacao > 0 ? '+' : '' }}{{ number_format($variacao, 1) }}% vs mês anterior
            </small>
        @endif
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-shopping-cart"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->total_vendas ?? 0 }}</div>
        <div class="stat-label">Total de Vendas</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->alunos_ativos ?? 0 }}</div>
        <div class="stat-label">Alunos Ativos</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-graduation-cap"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->alunos_concluidos ?? 0 }}</div>
        <div class="stat-label">Alunos Concluídos</div>
    </div>
</div>

<!-- Gráfico Vendas Diárias -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">Vendas por Dia - {{ \Carbon\Carbon::create($ano, $mes, 1)->locale('pt_BR')->translatedFormat('F Y') }}</h5>
    </div>
    <div class="card-body">
        <canvas id="vendasDiariasChart" height="80"></canvas>
    </div>
</div>

<!-- Gráfico Vendas 12 Meses -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">Evolução das Vendas (Últimos 12 Meses)</h5>
    </div>
    <div class="card-body">
        <canvas id="vendas12MesesChart" height="80"></canvas>
    </div>
</div>

<!-- Performance Especialistas -->
<div class="card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Performance dos Especialistas</h5>
        <button type="button" class="btn btn-primary" onclick="exportarVendas()">
            <i class="fas fa-download me-2"></i>Exportar
        </button>
    </div>
    <div class="card-body">
        @if($vendasEspecialistas->isNotEmpty())
            <div class="table-container">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Especialista</th>
                            <th>Vendas {{ \Carbon\Carbon::create($ano, $mes, 1)->locale('pt_BR')->translatedFormat('F') }}</th>
                            <th>Total de Vendas</th>
                            <th>Alunos Ativos</th>
                            <th>Alunos Concluídos</th>
                            <th>Taxa de Conclusão</th>
                            <th>Valor Médio</th>
                            <th>Performance</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($vendasEspecialistas as $esp)
                            <tr>
                                <td><strong>{{ $esp->nome }}</strong></td>
                                <td><span class="badge badge-primary">{{ $esp->vendas_mes }}</span></td>
                                <td>{{ $esp->total_vendas }}</td>
                                <td><span class="badge badge-success">{{ $esp->alunos_ativos }}</span></td>
                                <td><span class="badge badge-info">{{ $esp->alunos_concluidos }}</span></td>
                                <td>
                                    <div class="progress" style="height: 8px;">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ $esp->taxa_conclusao ?? 0 }}%"></div>
                                    </div>
                                    <small class="text-muted">{{ number_format($esp->taxa_conclusao ?? 0, 1) }}%</small>
                                </td>
                                <td>
                                    <span class="text-muted">
                                        N/A
                                    </span>
                                </td>
                                <td>
                                    @php
                                        $taxa = $esp->taxa_conclusao ?? 0;
                                    @endphp
                                    @if($taxa >= 80)
                                        <span class="badge badge-success">Excelente</span>
                                    @elseif($taxa >= 60)
                                        <span class="badge badge-info">Bom</span>
                                    @elseif($taxa >= 40)
                                        <span class="badge badge-warning">Regular</span>
                                    @else
                                        <span class="badge badge-danger">Baixo</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhuma venda encontrada</h5>
                <p class="text-muted">Não há vendas registradas para o período selecionado.</p>
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
// Gráfico vendas diárias
const vendasDiariasData = @json($vendasDiarias);
const labelsDiarias = vendasDiariasData.map(item => {
    const data = new Date(item.data);
    return data.getDate() + '/' + (data.getMonth() + 1);
});
const vendasDiarias = vendasDiariasData.map(item => item.vendas);

const ctxDiarias = document.getElementById('vendasDiariasChart').getContext('2d');
new Chart(ctxDiarias, {
    type: 'bar',
    data: {
        labels: labelsDiarias,
        datasets: [{
            label: 'Vendas',
            data: vendasDiarias,
            backgroundColor: 'rgba(34, 197, 94, 0.8)',
            borderColor: '#22c55e',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        }
    }
});

// Gráfico vendas 12 meses
const vendas12MesesData = @json($vendas12Meses);
const labels12Meses = vendas12MesesData.map(item => {
    const [ano, mes] = item.mes.split('-');
    const meses = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
    return `${meses[parseInt(mes) - 1]} ${ano}`;
});
const vendas12Meses = vendas12MesesData.map(item => item.vendas);

const ctx12Meses = document.getElementById('vendas12MesesChart').getContext('2d');
new Chart(ctx12Meses, {
    type: 'line',
    data: {
        labels: labels12Meses,
        datasets: [{
            label: 'Vendas',
            data: vendas12Meses,
            borderColor: '#22c55e',
            backgroundColor: 'rgba(34, 197, 94, 0.1)',
            borderWidth: 3,
            fill: true,
            tension: 0.4
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        }
    }
});

function exportarVendas() {
    const dados = @json($vendasEspecialistas);
    const headers = ['Especialista', 'Vendas do Mês', 'Total de Vendas', 'Alunos Ativos', 'Alunos Concluídos', 'Taxa de Conclusão', 'Valor Médio do Curso'];
    
    const csvContent = [
        headers.join(','),
        ...dados.map(row => [
            row.nome,
            row.vendas_mes,
            row.total_vendas,
            row.alunos_ativos,
            row.alunos_concluidos,
            (row.taxa_conclusao || 0) + '%',
            'R$ ' + (row.valor_medio_curso || 0).toFixed(2).replace('.', ',')
        ].join(','))
    ].join('\n');
    
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = `vendas_equipe_${{{ $mes }}}_${{{ $ano }}}.csv`;
    link.click();
}
</script>
@endpush

