@extends('layouts.especialista')

@section('title', 'Dashboard')

@section('content')
<div class="content-header">
    <h1 class="content-title">Olá, {{ Auth::user()->nome }}!</h1>
    <p class="content-subtitle">Bem-vindo ao seu painel de vendas</p>
</div>

<!-- Filtro de Período -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('especialista.dashboard') }}" class="row g-3">
            <div class="col-md-4">
                <label for="start_date" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $start }}">
            </div>
            <div class="col-md-4">
                <label for="end_date" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $end }}">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- KPIs -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value">{{ $leadsAtivos }}</div>
        <div class="stat-label">Leads Ativos</div>
    </div>

    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ $vendasPeriodo }}</div>
        <div class="stat-label">Vendas no Período</div>
        @if($metaMensal > 0)
        <div class="mt-2">
            <small class="text-muted">Meta: {{ $metaMensal }}</small>
            <div class="progress mt-1" style="height: 5px;">
                <div class="progress-bar bg-success" style="width: {{ min($progressoMeta, 100) }}%"></div>
            </div>
        </div>
        @endif
    </div>

    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ {{ number_format($receitaPeriodo, 2, ',', '.') }}</div>
        <div class="stat-label">Receita Gerada</div>
    </div>

    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #e9d5ff; color: #a855f7;">
                <i class="fas fa-percentage"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($taxaConversao, 1) }}%</div>
        <div class="stat-label">Taxa de Conversão</div>
    </div>
</div>

<!-- Alertas -->
@if($vendasPendentes > 0)
<div class="alert alert-warning">
    <i class="fas fa-clock me-2"></i>
    Você tem <strong>{{ $vendasPendentes }}</strong> venda(s) aguardando aprovação.
</div>
@endif

<!-- Gráfico de Evolução das Matrículas -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">
            <i class="fas fa-chart-line me-2"></i>
            Evolução das Matrículas
        </h5>
    </div>
    <div class="card-body">
        <canvas id="chartEvolucaoMatriculas" height="80"></canvas>
    </div>
</div>

<!-- Próximos Atendimentos -->
@if($proximosAtendimentos->count() > 0)
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Próximos Atendimentos</h5>
    </div>
    <div class="card-body">
        <div class="list-group list-group-flush">
            @foreach($proximosAtendimentos as $lead)
            <div class="list-group-item">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <strong>{{ $lead->nome }}</strong>
                        <small class="d-block text-muted">{{ $lead->telefone }}</small>
                    </div>
                    <div class="text-end">
                        <span class="badge bg-primary">{{ $lead->etapa }}</span>
                        <small class="d-block text-muted">
                            {{ \Carbon\Carbon::parse($lead->data_agendamento)->format('d/m/Y') }}
                            @if($lead->horario_agendamento)
                                {{ \Carbon\Carbon::parse($lead->horario_agendamento)->format('H:i') }}
                            @endif
                        </small>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endif
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Gráfico de Evolução das Matrículas
    const ctxEvolucao = document.getElementById('chartEvolucaoMatriculas');
    if (ctxEvolucao) {
        new Chart(ctxEvolucao.getContext('2d'), {
            type: 'line',
            data: {
                labels: {!! json_encode($evolucaoMatriculas->pluck('data')->map(function($d) { return \Carbon\Carbon::parse($d)->format('d/m'); })) !!},
                datasets: [{
                    label: 'Matrículas',
                    data: {!! json_encode($evolucaoMatriculas->pluck('total')) !!},
                    borderColor: '#3b82f6',
                    backgroundColor: 'rgba(59, 130, 246, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointRadius: 4,
                    pointHoverRadius: 6,
                    pointBackgroundColor: '#3b82f6',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: 'rgba(0, 0, 0, 0.8)',
                        padding: 12,
                        titleFont: {
                            size: 14,
                            weight: 'bold'
                        },
                        bodyFont: {
                            size: 13
                        },
                        callbacks: {
                            label: function(context) {
                                return 'Matrículas: ' + context.parsed.y;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1,
                            precision: 0
                        },
                        title: {
                            display: true,
                            text: 'Quantidade de Matrículas'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Data'
                        }
                    }
                }
            }
        });
    }
});
</script>
@endpush

