<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboard;
use App\Http\Controllers\Admin\LeadController as AdminLeadController;
use App\Http\Controllers\Admin\UsuarioController as AdminUsuarioController;
use App\Http\Controllers\Admin\VendaController as AdminVendaController;
use App\Http\Controllers\Admin\EquipeController as AdminEquipeController;
use App\Http\Controllers\Admin\VoucherController as AdminVoucherController;
use App\Http\Controllers\Admin\ContratoController as AdminContratoController;
use App\Http\Controllers\Admin\CategoriaController as AdminCategoriaController;
use App\Http\Controllers\Admin\MarketingController as AdminMarketingController;
use App\Http\Controllers\Admin\HorarioController as AdminHorarioController;
use App\Http\Controllers\Admin\AtendimentoController as AdminAtendimentoController;
use App\Http\Controllers\Admin\FinanceiroController as AdminFinanceiroController;
use App\Http\Controllers\Admin\RelatorioController as AdminRelatorioController;
use App\Http\Controllers\Admin\ConfiguracaoController as AdminConfiguracaoController;
use App\Http\Controllers\Admin\ValorCursoController as AdminValorCursoController;
use App\Http\Controllers\Admin\GestaoController as AdminGestaoController;
use App\Http\Controllers\Admin\ComissaoController as AdminComissaoController;
use App\Http\Controllers\Especialista\DashboardController as EspecialistaDashboard;
use App\Http\Controllers\Especialista\NegociacaoController as EspecialistaNegociacao;
use App\Http\Controllers\Coordenador\DashboardController as CoordenadorDashboard;
use App\Http\Controllers\LinkRedirectController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Rota inicial - redireciona para login
Route::get('/', function () {
    return redirect()->route('login');
})->name('home');

// Rota pública para links de marketing (redirecionamento e contagem)
Route::get('/l/{codigo}', [LinkRedirectController::class, 'redirect'])->name('link.redirect');

// ============================================
// ROTAS DE AUTENTICAÇÃO
// ============================================
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login'])->name('login.post');
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// ============================================
// ROTAS DO ADMIN
// ============================================
Route::prefix('admin')->name('admin.')->middleware(['auth', 'check.role:admin'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [AdminDashboard::class, 'index'])->name('dashboard');
    
    // Leads
    Route::prefix('leads')->name('leads.')->group(function () {
        Route::get('/', [AdminLeadController::class, 'index'])->name('index');
        Route::post('/', [AdminLeadController::class, 'store'])->name('store');
        Route::get('/{id}', [AdminLeadController::class, 'show'])->name('show');
        Route::post('/distribuir-para-equipe', [AdminLeadController::class, 'distribuirParaEquipe'])->name('distribuir-para-equipe');
        Route::post('/distribuir-para-especialista', [AdminLeadController::class, 'distribuirParaEspecialista'])->name('distribuir-para-especialista');
        Route::post('/toggle-distribuicao-automatica', [AdminLeadController::class, 'toggleDistribuicaoAutomatica'])->name('toggle-distribuicao-automatica');
    });
    
    // Usuários
    Route::resource('usuarios', AdminUsuarioController::class);
    
    // Vendas
    Route::prefix('vendas')->name('vendas.')->group(function () {
        Route::get('/', [AdminVendaController::class, 'index'])->name('index');
        Route::get('/{id}', [AdminVendaController::class, 'show'])->name('show');
        Route::post('/{id}/aprovar', [AdminVendaController::class, 'aprovar'])->name('aprovar');
        Route::post('/{id}/rejeitar', [AdminVendaController::class, 'rejeitar'])->name('rejeitar');
    });
    
    // Equipes
    Route::resource('equipes', AdminEquipeController::class);
    
    // Vouchers
    Route::resource('vouchers', AdminVoucherController::class);
    Route::post('vouchers/{id}/toggle-status', [AdminVoucherController::class, 'toggleStatus'])->name('vouchers.toggle-status');
    
    // Contratos
    Route::resource('contratos', AdminContratoController::class);
    Route::post('contratos/{id}/toggle-status', [AdminContratoController::class, 'toggleStatus'])->name('contratos.toggle-status');
    
    // Categorias
    Route::resource('categorias', AdminCategoriaController::class);
    Route::post('categorias/{id}/toggle-status', [AdminCategoriaController::class, 'toggleStatus'])->name('categorias.toggle-status');
    
    // Marketing
    Route::prefix('marketing')->name('marketing.')->group(function () {
        Route::get('/', [AdminMarketingController::class, 'index'])->name('index');
        Route::get('/create', [AdminMarketingController::class, 'create'])->name('create');
        Route::post('/', [AdminMarketingController::class, 'store'])->name('store');
        Route::get('/{id}', [AdminMarketingController::class, 'show'])->name('show');
        Route::post('/{id}/toggle-status', [AdminMarketingController::class, 'toggleStatus'])->name('toggle-status');
    });
    
    // Horários
    Route::prefix('horarios')->name('horarios.')->group(function () {
        Route::get('/', [AdminHorarioController::class, 'index'])->name('index');
        Route::post('/update', [AdminHorarioController::class, 'update'])->name('update');
        Route::post('/excecao', [AdminHorarioController::class, 'criarExcecao'])->name('excecao');
        Route::delete('/excecao/{id}', [AdminHorarioController::class, 'excluirExcecao'])->name('excecao.destroy');
    });
    
    // Atendimentos (Kanban Geral)
    Route::prefix('atendimentos')->name('atendimentos.')->group(function () {
        Route::get('/', [AdminAtendimentoController::class, 'index'])->name('index');
        Route::post('/{id}/status', [AdminAtendimentoController::class, 'atualizarStatus'])->name('status');
    });
    
    // Financeiro
    Route::prefix('financeiro')->name('financeiro.')->group(function () {
        Route::get('/', [AdminFinanceiroController::class, 'index'])->name('index');
        Route::get('/exportar', [AdminFinanceiroController::class, 'exportar'])->name('exportar');
    });
    
    // Comissões
    Route::prefix('comissoes')->name('comissoes.')->group(function () {
        Route::get('/', [AdminComissaoController::class, 'index'])->name('index');
        Route::get('/create', [AdminComissaoController::class, 'create'])->name('create');
        Route::post('/', [AdminComissaoController::class, 'store'])->name('store');
        Route::post('/calcular-comissao', [AdminComissaoController::class, 'calcularComissao'])->name('calcular-comissao');
        Route::get('/{id}', [AdminComissaoController::class, 'show'])->name('show');
        Route::get('/{id}/edit', [AdminComissaoController::class, 'edit'])->name('edit');
        Route::put('/{id}', [AdminComissaoController::class, 'update'])->name('update');
        Route::delete('/{id}', [AdminComissaoController::class, 'destroy'])->name('destroy');
        Route::post('/{id}/toggle-status', [AdminComissaoController::class, 'toggleStatus'])->name('toggle-status');
    });
    
    // Relatórios
    Route::prefix('relatorios')->name('relatorios.')->group(function () {
        Route::get('/', [AdminRelatorioController::class, 'index'])->name('index');
        Route::get('/vendas', [AdminRelatorioController::class, 'vendas'])->name('vendas');
        Route::get('/performance', [AdminRelatorioController::class, 'performance'])->name('performance');
        Route::get('/funil', [AdminRelatorioController::class, 'funil'])->name('funil');
        Route::get('/exportar', [AdminRelatorioController::class, 'exportar'])->name('exportar');
    });
    
    // Configurações
    Route::prefix('configuracoes')->name('configuracoes.')->group(function () {
        Route::get('/', [AdminConfiguracaoController::class, 'index'])->name('index');
        Route::post('/update', [AdminConfiguracaoController::class, 'update'])->name('update');
        Route::post('/toggle-distribuicao', [AdminConfiguracaoController::class, 'toggleDistribuicaoAutomatica'])->name('toggle-distribuicao');
    });
    
    // Valores de Curso
    Route::prefix('valores-curso')->name('valores-curso.')->group(function () {
        Route::get('/', [AdminValorCursoController::class, 'index'])->name('index');
        Route::post('/atualizar', [AdminValorCursoController::class, 'atualizarValorIntegral'])->name('atualizar');
    });
    
    // Gestão Avançada
    Route::prefix('gestao')->name('gestao.')->group(function () {
        Route::get('/', [AdminGestaoController::class, 'index'])->name('index');
        Route::post('/transferir', [AdminGestaoController::class, 'transferir'])->name('transferir');
    });
});

// ============================================
// ROTAS DO ESPECIALISTA
// ============================================
Route::prefix('especialista')->name('especialista.')->middleware(['auth', 'check.role:especialista'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [EspecialistaDashboard::class, 'index'])->name('dashboard');
    
    // Atendimentos (Kanban)
    Route::prefix('atendimentos')->name('atendimentos.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Especialista\AtendimentoController::class, 'index'])->name('index');
        Route::post('/{id}/status', [\App\Http\Controllers\Especialista\AtendimentoController::class, 'atualizarStatus'])->name('status');
        Route::get('/modal-negociacao/{leadId}', [\App\Http\Controllers\Especialista\NegociacaoModalController::class, 'getModal'])->name('modal-negociacao');
        Route::post('/salvar-negociacao', [\App\Http\Controllers\Especialista\NegociacaoModalController::class, 'salvarNegociacao'])->name('salvar-negociacao');
    });
    
    // Negociação
    Route::prefix('negociacao')->name('negociacao.')->group(function () {
        Route::get('/', [EspecialistaNegociacao::class, 'index'])->name('index');
        Route::get('/{id}', [EspecialistaNegociacao::class, 'show'])->name('show');
        Route::post('/{id}/status', [EspecialistaNegociacao::class, 'atualizarStatus'])->name('status');
        Route::post('/{id}/atendimento', [EspecialistaNegociacao::class, 'registrarAtendimento'])->name('atendimento');
        Route::post('/{id}/venda', [EspecialistaNegociacao::class, 'criarVenda'])->name('venda');
    });
    
    // Meus Alunos
    Route::prefix('meus-alunos')->name('meus-alunos.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Especialista\AlunoController::class, 'index'])->name('index');
    });
    
    // Comissões
    Route::prefix('comissoes')->name('comissoes.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Especialista\ComissaoController::class, 'index'])->name('index');
    });
    
    // Vouchers
    Route::prefix('vouchers')->name('vouchers.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Especialista\VoucherController::class, 'index'])->name('index');
    });
    
    // Meu Link
    Route::prefix('meu-link')->name('meu-link.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Especialista\LinkController::class, 'index'])->name('index');
    });
    
    // Perfil
    Route::prefix('perfil')->name('perfil.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Especialista\PerfilController::class, 'index'])->name('index');
        Route::post('/update', [\App\Http\Controllers\Especialista\PerfilController::class, 'update'])->name('update');
        Route::post('/change-password', [\App\Http\Controllers\Especialista\PerfilController::class, 'changePassword'])->name('change-password');
    });
    
    // Logs Pagamento
    Route::prefix('logs-pagamento')->name('logs-pagamento.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Especialista\LogPagamentoController::class, 'index'])->name('index');
    });
    
    // Confirmação de Pagamento
    Route::post('/pagamento/{negociacaoId}/confirmar', [\App\Http\Controllers\Especialista\PagamentoController::class, 'confirmarPagamento'])->name('pagamento.confirmar');
});

// ============================================
// ROTAS DO COORDENADOR
// ============================================
Route::prefix('coordenador')->name('coordenador.')->middleware(['auth', 'check.role:coordenador'])->group(function () {
    Route::get('/dashboard', [CoordenadorDashboard::class, 'index'])->name('dashboard');
    
    // Leads
    Route::get('/leads', [\App\Http\Controllers\Coordenador\LeadController::class, 'index'])->name('leads.index');
    Route::post('/leads/distribuir-automatico', [\App\Http\Controllers\Coordenador\LeadController::class, 'distribuirAutomatico'])->name('leads.distribuir-automatico');
    Route::post('/leads/distribuir-manual', [\App\Http\Controllers\Coordenador\LeadController::class, 'distribuirManual'])->name('leads.distribuir-manual');
    
    // Especialistas
    Route::get('/especialistas', [\App\Http\Controllers\Coordenador\EspecialistaController::class, 'index'])->name('especialistas.index');
    Route::post('/especialistas/adicionar', [\App\Http\Controllers\Coordenador\EspecialistaController::class, 'adicionar'])->name('especialistas.adicionar');
    Route::post('/especialistas/remover', [\App\Http\Controllers\Coordenador\EspecialistaController::class, 'remover'])->name('especialistas.remover');
    
    // Equipes
    Route::get('/equipes', [\App\Http\Controllers\Coordenador\EquipeController::class, 'index'])->name('equipes.index');
    Route::put('/equipes/{id}', [\App\Http\Controllers\Coordenador\EquipeController::class, 'update'])->name('equipes.update');
    
    // Alunos
    Route::get('/alunos', [\App\Http\Controllers\Coordenador\AlunoController::class, 'index'])->name('alunos.index');
    
    // Vendas
    Route::get('/vendas', [\App\Http\Controllers\Coordenador\VendaController::class, 'index'])->name('vendas.index');
    Route::get('/vendas/aguardando-aprovacao', [\App\Http\Controllers\Coordenador\VendaController::class, 'aguardandoAprovacao'])->name('vendas.aguardando-aprovacao');
    Route::post('/vendas/{id}/aprovar', [\App\Http\Controllers\Coordenador\VendaController::class, 'aprovar'])->name('vendas.aprovar');
    
    // Relatórios
    Route::get('/relatorios', [\App\Http\Controllers\Coordenador\RelatorioController::class, 'index'])->name('relatorios.index');
    
    // Feedback
    Route::get('/feedback', [\App\Http\Controllers\Coordenador\FeedbackController::class, 'index'])->name('feedback.index');
    Route::post('/feedback', [\App\Http\Controllers\Coordenador\FeedbackController::class, 'store'])->name('feedback.store');
    Route::post('/feedback/atualizar-status', [\App\Http\Controllers\Coordenador\FeedbackController::class, 'updateStatus'])->name('feedback.update-status');
    
    // Atendimentos (Kanban)
    Route::get('/atendimentos', [\App\Http\Controllers\Coordenador\AtendimentoController::class, 'index'])->name('atendimentos.index');
    Route::post('/atendimentos/{id}/status', [\App\Http\Controllers\Coordenador\AtendimentoController::class, 'atualizarStatus'])->name('atendimentos.atualizar-status');
});

// ============================================
// ROTAS PÚBLICAS (Webhooks)
// ============================================
// Webhook do Pagar.me para confirmação de pagamento
Route::post('/webhook/pagarme', [\App\Http\Controllers\Especialista\PagamentoController::class, 'webhookPagarMe'])->name('webhook.pagarme');
