

<?php $__env->startSection('title', 'Financeiro'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Financeiro</h1>
        <p class="content-subtitle">Gestão financeira e receitas</p>
    </div>
    <a href="<?php echo e(route('admin.financeiro.exportar', ['start_date' => $start, 'end_date' => $end])); ?>" class="btn btn-success">
        <i class="fas fa-file-excel me-2"></i>Exportar
    </a>
</div>

<!-- Filtro -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Data Início</label>
                <input type="date" class="form-control" name="start_date" value="<?php echo e($start); ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Data Fim</label>
                <input type="date" class="form-control" name="end_date" value="<?php echo e($end); ?>">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- KPIs -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-arrow-up"></i>
            </div>
            <div class="stat-value">R$ <?php echo e(number_format($totalReceita ?? 0, 2, ',', '.')); ?></div>
            <div class="stat-label">Receita Total</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-hand-holding-usd"></i>
            </div>
            <div class="stat-value">R$ <?php echo e(number_format($totalEntradas ?? 0, 2, ',', '.')); ?></div>
            <div class="stat-label">Investimento Parcial</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dcfce7; color: #16a34a;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-value">R$ <?php echo e(number_format($totalPago ?? 0, 2, ',', '.')); ?></div>
            <div class="stat-label">Total Pago</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #fee2e2; color: #ef4444;">
                <i class="fas fa-arrow-down"></i>
            </div>
            <div class="stat-value">R$ <?php echo e(number_format($totalPagamentos ?? 0, 2, ',', '.')); ?></div>
            <div class="stat-label">Pagamentos</div>
        </div>
    </div>
</div>
<?php if(isset($totalComissoes) && $totalComissoes > 0): ?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-percentage"></i>
            </div>
            <div class="stat-value">R$ <?php echo e(number_format($totalComissoes, 2, ',', '.')); ?></div>
            <div class="stat-label">Comissões</div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Receitas -->
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Receitas do Período</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Valor Total</th>
                        <th>Valor Fechado</th>
                        <th>Valor Pago</th>
                        <th>Investimento Parcial</th>
                        <th>Parcelas</th>
                        <th>Data</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $receitas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receita): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>#<?php echo e($receita->id); ?></td>
                        <td><strong>R$ <?php echo e(number_format($receita->valor_total ?? 0, 2, ',', '.')); ?></strong></td>
                        <td>R$ <?php echo e(number_format($receita->valor_fechado ?? 0, 2, ',', '.')); ?></td>
                        <td>R$ <?php echo e(number_format($receita->valor_pago ?? 0, 2, ',', '.')); ?></td>
                        <td>R$ <?php echo e(number_format($receita->investimento_parcial ?? 0, 2, ',', '.')); ?></td>
                        <td><?php echo e($receita->num_parcelas ?? 1); ?>x</td>
                        <td><?php echo e(\Carbon\Carbon::parse($receita->data_criacao)->format('d/m/Y H:i')); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">Nenhuma receita no período</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/financeiro/index.blade.php ENDPATH**/ ?>