

<?php $__env->startSection('title', 'Equipes'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Equipes</h1>
        <p class="content-subtitle">Gerenciamento de equipes de vendas</p>
    </div>
    <a href="<?php echo e(route('admin.equipes.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Nova Equipe
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Coordenador</th>
                        <th>Especialistas</th>
                        <th>Meta Mensal</th>
                        <th>Status</th>
                        <th>Data Criação</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $equipes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><strong><?php echo e($equipe->nome); ?></strong></td>
                        <td><?php echo e($equipe->coordenador?->nome ?? '-'); ?></td>
                        <td>
                            <span class="badge bg-primary"><?php echo e($equipe->especialistas_count ?? 0); ?></span>
                        </td>
                        <td><?php echo e($equipe->meta_mensal > 0 ? number_format($equipe->meta_mensal, 0) : '-'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($equipe->status === 'ativo' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($equipe->status)); ?>

                            </span>
                        </td>
                        <td>-</td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.equipes.show', $equipe->id)); ?>" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.equipes.edit', $equipe->id)); ?>" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma equipe encontrada</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($equipes->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($equipes->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/equipes/index.blade.php ENDPATH**/ ?>