

<?php $__env->startSection('title', 'Novo Link de Marketing'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.marketing.index')); ?>">Marketing</a></li>
            <li class="breadcrumb-item active">Novo</li>
        </ol>
    </nav>
    <h1 class="content-title">Novo Link de Marketing</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('admin.marketing.store')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-3">
                <label for="nome" class="form-label">Nome da Campanha *</label>
                <input type="text" class="form-control" id="nome" name="nome" value="<?php echo e(old('nome')); ?>" required>
                <small class="text-muted">Nome interno para identificar a campanha</small>
            </div>

            <div class="mb-3">
                <label for="url_destino" class="form-label">URL de Destino</label>
                <input type="text" class="form-control bg-light" id="url_destino" name="url_destino" 
                       value="https://vencerleitura.com.br/agendamento" readonly>
                <small class="text-muted">URL fixa para captura de leads</small>
            </div>

            <div class="alert alert-info">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Como funciona:</strong> O sistema gerará automaticamente um código único e uma URL com parâmetros UTM para rastreamento.
                Quando alguém clicar no link, será contabilizado e o lead será capturado com a origem identificada.
            </div>

            <hr class="my-4">
            <h5 class="mb-3">
                <i class="fas fa-tags me-2" style="color: #667eea;"></i>Parâmetros UTM para Rastreamento
            </h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="utm_source" class="form-label">
                        UTM Source * 
                        <i class="fas fa-question-circle text-muted" title="De onde vem o tráfego"></i>
                    </label>
                    <input type="text" class="form-control" id="utm_source" name="utm_source" 
                           value="<?php echo e(old('utm_source')); ?>" placeholder="Ex: facebook, google, instagram" required>
                    <small class="text-muted">Origem do tráfego</small>
                </div>
                <div class="col-md-6">
                    <label for="utm_medium" class="form-label">
                        UTM Medium *
                        <i class="fas fa-question-circle text-muted" title="Tipo de mídia"></i>
                    </label>
                    <input type="text" class="form-control" id="utm_medium" name="utm_medium" 
                           value="<?php echo e(old('utm_medium')); ?>" placeholder="Ex: cpc, social, email" required>
                    <small class="text-muted">Tipo de mídia</small>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="utm_campaign" class="form-label">
                        UTM Campaign *
                        <i class="fas fa-question-circle text-muted" title="Nome da campanha"></i>
                    </label>
                    <input type="text" class="form-control" id="utm_campaign" name="utm_campaign" 
                           value="<?php echo e(old('utm_campaign')); ?>" placeholder="Ex: black_friday_2025" required>
                    <small class="text-muted">Nome da campanha</small>
                </div>
                <div class="col-md-6">
                    <label for="utm_content" class="form-label">
                        UTM Content
                        <i class="fas fa-question-circle text-muted" title="Variação do anúncio"></i>
                    </label>
                    <input type="text" class="form-control" id="utm_content" name="utm_content" 
                           value="<?php echo e(old('utm_content')); ?>" placeholder="Ex: banner_topo, link_bio">
                    <small class="text-muted">Opcional - Variação do anúncio</small>
                </div>
            </div>

            <div class="mb-3">
                <label for="utm_term" class="form-label">
                    UTM Term
                    <i class="fas fa-question-circle text-muted" title="Palavra-chave"></i>
                </label>
                <input type="text" class="form-control" id="utm_term" name="utm_term" 
                       value="<?php echo e(old('utm_term')); ?>" placeholder="Ex: curso_leitura_rapida">
                <small class="text-muted">Opcional - Palavra-chave da campanha</small>
            </div>

            <div class="alert alert-success">
                <i class="fas fa-magic me-2"></i>
                <strong>Link será gerado automaticamente:</strong> 
                <code><?php echo e(url('/l/')); ?>/XXXXXXXX</code>
                <br>
                <small>Ao criar, você receberá um link curto que redireciona para vencerleitura.com.br/agendamento com todos os parâmetros UTM</small>
            </div>

            <div class="text-end">
                <a href="<?php echo e(route('admin.marketing.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Criar Link
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/marketing/create.blade.php ENDPATH**/ ?>