

<?php $__env->startSection('title', 'Vendas'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Aprovar Vendas</h1>
    <p class="content-subtitle">Gerenciamento e aprovação de vendas</p>
</div>

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-value"><?php echo e($stats['pendentes']); ?></div>
            <div class="stat-label">Pendentes</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-value"><?php echo e($stats['aprovadas']); ?></div>
            <div class="stat-label">Aprovadas</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #fee2e2; color: #ef4444;">
                <i class="fas fa-times-circle"></i>
            </div>
            <div class="stat-value"><?php echo e($stats['rejeitadas']); ?></div>
            <div class="stat-label">Rejeitadas</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-dollar-sign"></i>
            </div>
            <div class="stat-value">R$ <?php echo e(number_format($stats['total_mes'], 2, ',', '.')); ?></div>
            <div class="stat-label">Total do Mês</div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.vendas.index')); ?>" class="row g-3">
            <div class="col-md-2">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                    <option value="">Todos</option>
                    <option value="pendente" <?php echo e(request('status') === 'pendente' ? 'selected' : ''); ?>>Pendente</option>
                    <option value="aprovada" <?php echo e(request('status') === 'aprovada' ? 'selected' : ''); ?>>Aprovada</option>
                    <option value="rejeitada" <?php echo e(request('status') === 'rejeitada' ? 'selected' : ''); ?>>Rejeitada</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="data_inicio" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="data_inicio" name="data_inicio" value="<?php echo e(request('data_inicio')); ?>">
            </div>
            <div class="col-md-3">
                <label for="data_fim" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="data_fim" name="data_fim" value="<?php echo e(request('data_fim')); ?>">
            </div>
            <div class="col-md-3">
                <label for="search" class="form-label">Buscar</label>
                <input type="text" class="form-control" id="search" name="search" value="<?php echo e(request('search')); ?>" placeholder="Nome do lead">
            </div>
            <div class="col-md-1 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Tabela -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Lead</th>
                        <th>Especialista</th>
                        <th>Valor Total</th>
                        <th>Forma Pagamento</th>
                        <th>Status</th>
                        <th>Data Venda</th>
                        <th width="150">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $vendas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venda): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><strong>#<?php echo e($venda->id); ?></strong></td>
                        <td><?php echo e($venda->lead?->nome ?? '-'); ?></td>
                        <td><?php echo e($venda->especialista?->usuario?->nome ?? '-'); ?></td>
                        <td><strong>R$ <?php echo e(number_format($venda->valor_total, 2, ',', '.')); ?></strong></td>
                        <td>
                            <?php
                                $formas = [
                                    'dinheiro' => 'Dinheiro',
                                    'pix' => 'PIX',
                                    'cartao_credito' => 'Cartão Crédito',
                                    'cartao_debito' => 'Cartão Débito',
                                    'boleto' => 'Boleto',
                                ];
                            ?>
                            <?php echo e($formas[$venda->forma_pagamento] ?? $venda->forma_pagamento); ?>

                        </td>
                        <td>
                            <?php
                                $statusBadges = [
                                    'pendente' => 'warning',
                                    'aprovada' => 'success',
                                    'rejeitada' => 'danger',
                                ];
                                $badge = $statusBadges[$venda->status] ?? 'secondary';
                            ?>
                            <span class="badge bg-<?php echo e($badge); ?>"><?php echo e(ucfirst($venda->status)); ?></span>
                        </td>
                        <td><?php echo e($venda->data_venda?->format('d/m/Y H:i') ?? '-'); ?></td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.vendas.show', $venda->id)); ?>" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if($venda->status === 'pendente'): ?>
                                <button type="button" class="btn btn-outline-success" onclick="aprovarVenda(<?php echo e($venda->id); ?>)" title="Aprovar">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button type="button" class="btn btn-outline-danger" onclick="rejeitarVenda(<?php echo e($venda->id); ?>)" title="Rejeitar">
                                    <i class="fas fa-times"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma venda encontrada</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($vendas->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($vendas->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal de Rejeição -->
<div class="modal fade" id="modalRejeitar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Rejeitar Venda</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="motivo_rejeicao" class="form-label">Motivo da Rejeição</label>
                    <textarea class="form-control" id="motivo_rejeicao" rows="3" required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-danger" onclick="confirmarRejeicao()">Rejeitar Venda</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let vendaIdRejeitar = null;

function aprovarVenda(id) {
    if (!confirm('Tem certeza que deseja aprovar esta venda?')) {
        return;
    }

    fetch(`/admin/vendas/${id}/aprovar`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        alert('Erro ao aprovar venda');
        console.error(error);
    });
}

function rejeitarVenda(id) {
    vendaIdRejeitar = id;
    document.getElementById('motivo_rejeicao').value = '';
    new bootstrap.Modal(document.getElementById('modalRejeitar')).show();
}

function confirmarRejeicao() {
    const motivo = document.getElementById('motivo_rejeicao').value;
    
    if (!motivo.trim()) {
        alert('Por favor, informe o motivo da rejeição');
        return;
    }

    fetch(`/admin/vendas/${vendaIdRejeitar}/rejeitar`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ motivo })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        alert('Erro ao rejeitar venda');
        console.error(error);
    });
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/vendas/index.blade.php ENDPATH**/ ?>