

<?php $__env->startSection('title', 'Comissões'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Gerenciamento de Comissões</h1>
        <p class="content-subtitle">Gerencie as comissões dos especialistas</p>
    </div>
    <a href="<?php echo e(route('admin.comissoes.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Nova Comissão
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error') || $errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        <?php echo e(session('error') ?? $errors->first()); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-primary bg-opacity-10 rounded p-3">
                            <i class="fas fa-dollar-sign fa-2x text-primary"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ <?php echo e(number_format($stats['total'] ?? 0, 2, ',', '.')); ?></div>
                        <small class="text-muted">Total de Comissões</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-warning bg-opacity-10 rounded p-3">
                            <i class="fas fa-clock fa-2x text-warning"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ <?php echo e(number_format($stats['pendentes'] ?? 0, 2, ',', '.')); ?></div>
                        <small class="text-muted">Pendentes</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-info bg-opacity-10 rounded p-3">
                            <i class="fas fa-check-circle fa-2x text-info"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ <?php echo e(number_format($stats['liberadas'] ?? 0, 2, ',', '.')); ?></div>
                        <small class="text-muted">Liberadas</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <div class="bg-success bg-opacity-10 rounded p-3">
                            <i class="fas fa-check-double fa-2x text-success"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="h3 mb-0">R$ <?php echo e(number_format($stats['pagas'] ?? 0, 2, ',', '.')); ?></div>
                        <small class="text-muted">Pagas</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.comissoes.index')); ?>" class="row g-3">
            <div class="col-md-3">
                <label for="especialista_id" class="form-label">Especialista</label>
                <select class="form-select" id="especialista_id" name="especialista_id">
                    <option value="">Todos</option>
                    <?php $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $esp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($esp->id); ?>" <?php echo e(request('especialista_id') == $esp->id ? 'selected' : ''); ?>>
                            <?php echo e($esp->nome); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                    <option value="">Todos</option>
                    <option value="pendente" <?php echo e(request('status') === 'pendente' ? 'selected' : ''); ?>>Pendente</option>
                    <option value="liberada" <?php echo e(request('status') === 'liberada' ? 'selected' : ''); ?>>Liberada</option>
                    <option value="paga" <?php echo e(request('status') === 'paga' ? 'selected' : ''); ?>>Paga</option>
                </select>
            </div>
            <div class="col-md-2">
                <label for="data_inicio" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="data_inicio" name="data_inicio" value="<?php echo e(request('data_inicio')); ?>">
            </div>
            <div class="col-md-2">
                <label for="data_fim" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="data_fim" name="data_fim" value="<?php echo e(request('data_fim')); ?>">
            </div>
            <div class="col-md-2">
                <label for="search" class="form-label">Buscar</label>
                <input type="text" class="form-control" id="search" name="search" value="<?php echo e(request('search')); ?>" placeholder="Nome, ID...">
            </div>
            <div class="col-md-1 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Tabela -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Especialista</th>
                        <th>Lead</th>
                        <th>Negociação</th>
                        <th>Percentual</th>
                        <th>Valor</th>
                        <th>Status</th>
                        <th>Data Prevista</th>
                        <th width="150">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $comissoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comissao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><strong>#<?php echo e($comissao->id); ?></strong></td>
                        <td>
                            <div>
                                <strong><?php echo e($comissao->especialista_nome); ?></strong>
                                <br>
                                <small class="text-muted"><?php echo e($comissao->especialista_email); ?></small>
                            </div>
                        </td>
                        <td><?php echo e($comissao->lead_nome ?? '-'); ?></td>
                        <td>
                            <div>
                                <strong>R$ <?php echo e(number_format($comissao->negociacao_valor ?? 0, 2, ',', '.')); ?></strong>
                                <br>
                                <small class="text-muted">ID: <?php echo e($comissao->negociacao_id); ?></small>
                            </div>
                        </td>
                        <td><?php echo e(number_format($comissao->percentual, 2, ',', '.')); ?>%</td>
                        <td><strong class="text-success">R$ <?php echo e(number_format($comissao->valor, 2, ',', '.')); ?></strong></td>
                        <td>
                            <?php
                                $badges = [
                                    'pendente' => 'warning',
                                    'liberada' => 'info',
                                    'paga' => 'success',
                                ];
                                $badge = $badges[$comissao->status] ?? 'secondary';
                            ?>
                            <span class="badge bg-<?php echo e($badge); ?>" id="status-badge-<?php echo e($comissao->id); ?>">
                                <?php echo e(ucfirst($comissao->status)); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($comissao->data_prevista): ?>
                                <?php echo e(\Carbon\Carbon::parse($comissao->data_prevista)->format('d/m/Y')); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.comissoes.show', $comissao->id)); ?>" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.comissoes.edit', $comissao->id)); ?>" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php if($comissao->status !== 'paga'): ?>
                                <button type="button" class="btn btn-outline-success" onclick="atualizarStatus(<?php echo e($comissao->id); ?>, '<?php echo e($comissao->status); ?>')" title="Atualizar Status">
                                    <i class="fas fa-sync"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma comissão encontrada</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($comissoes->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($comissoes->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal Atualizar Status -->
<div class="modal fade" id="modalStatus" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Atualizar Status da Comissão</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="comissao_id_status">
                <div class="mb-3">
                    <label for="novo_status" class="form-label">Novo Status</label>
                    <select class="form-select" id="novo_status">
                        <option value="pendente">Pendente</option>
                        <option value="liberada">Liberada</option>
                        <option value="paga">Paga</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarAtualizacaoStatus()">Atualizar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function atualizarStatus(comissaoId, statusAtual) {
    document.getElementById('comissao_id_status').value = comissaoId;
    document.getElementById('novo_status').value = statusAtual === 'pendente' ? 'liberada' : 'paga';
    new bootstrap.Modal(document.getElementById('modalStatus')).show();
}

function confirmarAtualizacaoStatus() {
    const comissaoId = document.getElementById('comissao_id_status').value;
    const novoStatus = document.getElementById('novo_status').value;

    fetch(`<?php echo e(route('admin.comissoes.index')); ?>/${comissaoId}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ status: novoStatus })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert('Erro: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao atualizar status');
    });
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/comissoes/index.blade.php ENDPATH**/ ?>