

<?php $__env->startSection('title', 'Meu Link'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Meus Links de Cadastro</h1>
    <p class="content-subtitle">Compartilhe seus links personalizados para cadastro de alunos</p>
</div>

<div class="card mb-4">
    <div class="card-body">
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i>
            <strong>Links Únicos:</strong> Estes são seus links pessoais para cadastro de alunos. 
            Cada matrícula realizada através destes links será automaticamente vinculada a você.
        </div>

        <!-- Link para Alunos Regulares -->
        <div class="mb-4">
            <div class="card border-primary">
                <div class="card-header bg-primary text-white">
                    <h6 class="mb-0">
                        <i class="fas fa-user me-2"></i>Link para Alunos Regulares
                    </h6>
                </div>
                <div class="card-body">
                    <div class="input-group mb-2">
                        <input type="text" class="form-control" id="linkRegular" value="<?php echo e($linkRegular); ?>" readonly>
                        <button class="btn btn-primary" type="button" onclick="copiarLink('linkRegular', 'primary')">
                            <i class="fas fa-copy"></i> Copiar Link
                        </button>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-dollar-sign me-1"></i>
                        Use este link para alunos que pagarão o valor integral do curso.
                    </small>
                </div>
            </div>
        </div>

        <!-- Link para Alunos Bolsistas -->
        <div class="mb-4">
            <div class="card border-success">
                <div class="card-header bg-success text-white">
                    <h6 class="mb-0">
                        <i class="fas fa-graduation-cap me-2"></i>Link para Alunos Bolsistas
                    </h6>
                </div>
                <div class="card-body">
                    <div class="input-group mb-2">
                        <input type="text" class="form-control" id="linkBolsista" value="<?php echo e($linkBolsista); ?>" readonly>
                        <button class="btn btn-success" type="button" onclick="copiarLink('linkBolsista', 'success')">
                            <i class="fas fa-copy"></i> Copiar Link
                        </button>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-percentage me-1"></i>
                        Use este link para alunos que receberão desconto ou bolsa de estudos.
                    </small>
                </div>
            </div>
        </div>

        <!-- Instruções de uso -->
        <div class="alert alert-warning">
            <h6><i class="fas fa-exclamation-triangle me-2"></i>Importante:</h6>
            <ul class="mb-0">
                <li>Estes links são únicos e pessoais para você</li>
                <li>Todas as matrículas realizadas através destes links serão contabilizadas em seu nome</li>
                <li>Use o link correto baseado no tipo de aluno que você está atendendo</li>
                <li>Não compartilhe estes links com outros especialistas</li>
            </ul>
        </div>

        <div class="mt-4">
            <h6><i class="fas fa-question-circle me-2"></i>Como usar:</h6>
            <ol>
                <li><strong>Escolha o link apropriado</strong> baseado no tipo de aluno (Regular ou Bolsista)</li>
                <li><strong>Copie o link</strong> clicando no botão "Copiar Link"</li>
                <li><strong>Envie o link</strong> para seu aluno através de e-mail, WhatsApp ou outra forma de comunicação</li>
                <li><strong>O aluno se cadastra</strong> através do link e é automaticamente vinculado a você</li>
                <li><strong>A matrícula é contabilizada</strong> quando o aluno: preencher o cadastro + aceitar o contrato + investir R$ 660,00 ou mais</li>
            </ol>
        </div>
    </div>
</div>

<!-- Estatísticas -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-user"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($totalRegular); ?></div>
        <div class="stat-label">Alunos Regulares</div>
        <small class="text-muted">Cadastrados</small>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-graduation-cap"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($totalBolsista); ?></div>
        <div class="stat-label">Alunos Bolsistas</div>
        <small class="text-muted">Cadastrados</small>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($totalMatriculasEfetivadas); ?></div>
        <div class="stat-label">Matrículas</div>
        <small class="text-muted">Efetivadas (R$ 660+)</small>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-calendar"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($alunos30Dias); ?></div>
        <div class="stat-label">Últimos 30 dias</div>
        <small class="text-muted">Novos cadastros</small>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function copiarLink(inputId, btnType) {
    var copyText = document.getElementById(inputId);
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    
    if (navigator.clipboard) {
        navigator.clipboard.writeText(copyText.value).then(function() {
            mostrarFeedback(inputId, btnType);
        }, function() {
            document.execCommand("copy");
            mostrarFeedback(inputId, btnType);
        });
    } else {
        document.execCommand("copy");
        mostrarFeedback(inputId, btnType);
    }
}

function mostrarFeedback(inputId, btnType) {
    var btn = document.getElementById(inputId).nextElementSibling;
    var originalText = btn.innerHTML;
    var originalClass = 'btn-' + btnType;
    
    btn.innerHTML = '<i class="fas fa-check"></i> Copiado!';
    btn.classList.remove(originalClass);
    btn.classList.add('btn-success');
    
    setTimeout(function() {
        btn.innerHTML = originalText;
        btn.classList.remove('btn-success');
        btn.classList.add(originalClass);
    }, 2000);
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.especialista', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/especialista/meu-link/index.blade.php ENDPATH**/ ?>