

<?php $__env->startSection('title', 'Nova Equipe'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.equipes.index')); ?>">Equipes</a></li>
            <li class="breadcrumb-item active">Nova</li>
        </ol>
    </nav>
    <h1 class="content-title">Nova Equipe</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('admin.equipes.store')); ?>">
            <?php echo csrf_field(); ?>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="nome" class="form-label">Nome da Equipe *</label>
                    <input type="text" class="form-control <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="nome" name="nome" value="<?php echo e(old('nome')); ?>" required>
                    <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-md-6">
                    <label for="coordenador_id" class="form-label">Coordenador *</label>
                    <select class="form-select <?php $__errorArgs = ['coordenador_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            id="coordenador_id" name="coordenador_id" required>
                        <option value="">Selecione...</option>
                        <?php $__currentLoopData = $coordenadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coord): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($coord->id); ?>" <?php echo e(old('coordenador_id') == $coord->id ? 'selected' : ''); ?>>
                                <?php echo e($coord->nome); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['coordenador_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="meta_mensal" class="form-label">Meta Mensal</label>
                    <input type="number" class="form-control" id="meta_mensal" name="meta_mensal" 
                           value="<?php echo e(old('meta_mensal', 0)); ?>" min="0">
                </div>
                <div class="col-md-6">
                    <label for="status" class="form-label">Status *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="ativo" <?php echo e(old('status') === 'ativo' ? 'selected' : ''); ?>>Ativo</option>
                        <option value="inativo" <?php echo e(old('status') === 'inativo' ? 'selected' : ''); ?>>Inativo</option>
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Especialistas</label>
                <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                    <?php $__empty_1 = true; $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $esp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="especialistas[]" 
                                   value="<?php echo e($esp->id); ?>" id="esp<?php echo e($esp->id); ?>">
                            <label class="form-check-label" for="esp<?php echo e($esp->id); ?>">
                                <?php echo e($esp->nome); ?>

                            </label>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted">Nenhum especialista disponível</p>
                    <?php endif; ?>
                </div>
            </div>

            <div class="text-end">
                <a href="<?php echo e(route('admin.equipes.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Equipe
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/equipes/create.blade.php ENDPATH**/ ?>