<?php if($vinculoExistente): ?>
<div class="alert alert-warning">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <strong>Atenção!</strong> Este lead já está vinculado ao aluno <strong><?php echo e($vinculoExistente->aluno_id); ?></strong>.
    <br>
    <small>Se você continuar, o vínculo existente será atualizado.</small>
</div>
<?php endif; ?>

<form id="formNegociacaoModal" data-lead-id="<?php echo e($lead->id); ?>">
    <!-- Informações do Lead -->
    <div class="alert alert-info mb-3">
        <div class="row">
            <div class="col-md-6">
                <strong>Lead:</strong> <?php echo e($lead->nome); ?><br>
                <small><?php echo e($lead->email); ?> | <?php echo e($lead->telefone); ?></small>
            </div>
        </div>
    </div>

    <!-- Seleção de Aluno -->
    <div class="mb-3">
        <label for="aluno_existente_id" class="form-label">
            <i class="fas fa-user-graduate me-1"></i>Selecionar Aluno <span class="text-danger">*</span>
        </label>
        <select class="form-select" id="aluno_existente_id" name="aluno_existente_id" required>
            <option value="">Selecione um aluno...</option>
            <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($aluno->id); ?>" 
                    data-nome="<?php echo e($aluno->nome); ?>"
                    data-email="<?php echo e($aluno->email); ?>"
                    data-celular="<?php echo e($aluno->celular); ?>">
                <?php echo e($aluno->nome); ?> - <?php echo e($aluno->email); ?>

            </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <?php if($alunos->isEmpty()): ?>
        <small class="text-danger">Nenhum aluno disponível. Você precisa ter alunos cadastrados para criar uma negociação.</small>
        <?php endif; ?>
    </div>

    <!-- Valor do Curso -->
    <div class="mb-3">
        <label class="form-label">Valor do Curso (Integral Vigente)</label>
        <input type="text" class="form-control" value="R$ <?php echo e(number_format($valorIntegral, 2, ',', '.')); ?>" readonly>
        <input type="hidden" name="tipo_valor" value="integral">
    </div>

    <!-- Valor Total -->
    <div class="mb-3">
        <div id="valorTotalBoxModal" class="alert alert-success">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <strong>💰 Valor Total:</strong>
                    <div id="descontoInfoModal" class="text-muted small mt-1" style="display: none;">
                        <i class="fas fa-tag"></i> Desconto aplicado: <span id="descontoPercentualModal">0%</span>
                    </div>
                </div>
                <div>
                    <span id="valorOriginalModal" class="text-muted small" style="display: none; text-decoration: line-through;">
                        R$ <?php echo e(number_format($valorIntegral, 2, ',', '.')); ?>

                    </span>
                    <div id="valorTotalSpanModal" style="font-size: 1.5rem; font-weight: bold; color: #28a745;">
                        R$ <?php echo e(number_format($valorIntegral, 2, ',', '.')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Forma de Pagamento -->
    <div class="row mb-3">
        <div class="col-md-6">
            <label for="formaPagamento" class="form-label">
                <i class="fas fa-credit-card me-1"></i>Forma de Pagamento <span class="text-danger">*</span>
            </label>
            <select class="form-select" id="formaPagamento" name="forma_pagamento" required>
                <option value="credito">Cartão de Crédito</option>
                <option value="pix">PIX</option>
            </select>
        </div>
        <div class="col-md-6">
            <label for="numParcelasModal" class="form-label">
                <i class="fas fa-calendar-alt me-1"></i>Número de Parcelas <span class="text-danger">*</span>
            </label>
            <select class="form-select" id="numParcelasModal" name="num_parcelas" required>
                <option value="1">1x (sem juros)</option>
            </select>
        </div>
    </div>

    <!-- Voucher -->
    <div class="mb-3">
        <label for="voucherModal" class="form-label">
            <i class="fas fa-ticket-alt me-1"></i>Voucher de Desconto <small class="text-muted">(Opcional)</small>
        </label>
        <select class="form-select" id="voucherModal" name="voucher_id">
            <option value="" data-desconto="0">➖ Nenhum voucher selecionado</option>
            <?php $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($voucher->id); ?>" 
                    data-desconto="<?php echo e($voucher->percentual_desconto); ?>">
                🎟️ <?php echo e($voucher->codigo); ?> - <strong><?php echo e($voucher->percentual_desconto); ?>% OFF</strong>
                <?php if($voucher->valido_ate): ?>
                (válido até <?php echo e(\Carbon\Carbon::parse($voucher->valido_ate)->format('d/m/Y')); ?>)
                <?php endif; ?>
            </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <small class="text-muted">Desconto será aplicado sobre o valor integral do curso</small>
    </div>

    <!-- Investimento Parcial -->
    <div class="mb-3">
        <div class="form-check">
            <input class="form-check-input" type="checkbox" id="investimentoParcialCheck" name="investimento_parcial" value="1" onchange="toggleInvestimentoParcial()">
            <label class="form-check-label" for="investimentoParcialCheck">
                Investimento Parcial
            </label>
        </div>
    </div>

    <div id="investimentoParcialGroup" style="display: none;" class="mb-3">
        <label for="valorInvestido" class="form-label">Valor Investido (R$)</label>
        <input type="number" class="form-control" id="valorInvestido" name="valor_investido" step="0.01" min="0" oninput="calcularSaldoRestante()">
        <div id="saldoRestanteInfo" class="alert alert-info mt-2" style="display: none;">
            <strong>Saldo Restante:</strong> <span id="saldoRestanteValor">R$ 0,00</span>
        </div>
    </div>

    <!-- Data Segunda Parcela (PIX) -->
    <div id="segundaParcelaDiv" class="mb-3" style="display: none;">
        <label for="data_segunda_parcela" class="form-label">Data da Segunda Parcela (PIX)</label>
        <input type="date" class="form-control" id="data_segunda_parcela" name="data_segunda_parcela">
    </div>

    <div class="modal-footer mt-4">
        <button type="button" class="btn btn-secondary" onclick="closeNegociacaoModal()">
            <i class="fas fa-times me-2"></i>Cancelar
        </button>
        <button type="button" class="btn btn-primary" onclick="confirmNegociacao()">
            <i class="fas fa-check me-2"></i>Criar Negociação e Gerar Link
        </button>
    </div>
</form>

<script>
// Inicializar quando o modal for carregado
document.addEventListener('DOMContentLoaded', function() {
    if (document.getElementById('formNegociacaoModal')) {
        inicializarModalNegociacaoAtendimentos();
    }
});
</script>

<?php /**PATH C:\xampp\htdocs\equipe\resources\views/especialista/atendimentos/modal-negociacao.blade.php ENDPATH**/ ?>