

<?php $__env->startSection('title', 'Logs de Pagamento'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Logs de Negociações</h1>
    <p class="content-subtitle">Acompanhe suas negociações e status dos pagamentos</p>
</div>

<!-- Estatísticas -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-list"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($logs->count()); ?></div>
        <div class="stat-label">Total de Negociações</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-link"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($logs->where('status', 'fechado')->count()); ?></div>
        <div class="stat-label">Negociações Fechadas</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($totalPagos); ?></div>
        <div class="stat-label">Pagamentos Confirmados</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ <?php echo e(number_format($valorPago, 0, ',', '.')); ?></div>
        <div class="stat-label">Total Pago</div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">
            <i class="fas fa-history me-2"></i>
            Histórico de Negociações (<?php echo e($logs->count()); ?>)
        </h5>
    </div>
    <div class="card-body p-0">
        <?php if($logs->isEmpty()): ?>
            <div class="text-center py-5 text-muted">
                <i class="fas fa-inbox fa-3x mb-3"></i>
                <p>Nenhuma negociação encontrada</p>
                <small>Crie uma negociação na página de Atendimentos</small>
            </div>
        <?php else: ?>
            <div class="logs-container">
                <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="log-card">
                        <div class="log-header">
                            <div class="log-info-main">
                                <div class="log-title">
                                    <strong>Negociação #<?php echo e($log->negociacao_id); ?></strong>
                                    <span class="ms-2 text-muted">|</span>
                                    <span class="ms-2"><?php echo e($log->aluno_nome); ?></span>
                                    <?php if($log->lead_nome): ?>
                                        <span class="badge bg-info ms-2">
                                            <i class="fas fa-user-tag"></i> <?php echo e($log->lead_nome); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="log-meta">
                                    <span class="text-muted">
                                        <i class="fas fa-calendar"></i> <?php echo e(\Carbon\Carbon::parse($log->data_criacao)->format('d/m/Y H:i')); ?>

                                    </span>
                                    <span class="text-success ms-3">
                                        <i class="fas fa-dollar-sign"></i> <strong>R$ <?php echo e(number_format($log->valor_total, 2, ',', '.')); ?></strong>
                                    </span>
                                    <?php if($log->status == 'fechado' && $log->valor_pago > 0): ?>
                                        <span class="badge bg-success ms-3">
                                            <i class="fas fa-check-circle"></i> Pago
                                        </span>
                                    <?php elseif($log->status == 'fechado'): ?>
                                        <span class="badge bg-info ms-3">
                                            <i class="fas fa-check"></i> Fechado
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-warning ms-3">
                                            <i class="fas fa-clock"></i> Em Andamento
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="log-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-dollar-sign"></i> Valor Total
                                    </small>
                                    <strong class="text-primary">R$ <?php echo e(number_format($log->valor_total ?? 0, 2, ',', '.')); ?></strong>
                                </div>
                                
                                <div class="col-md-6">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-wallet"></i> Valor Pago
                                    </small>
                                    <strong class="text-success">R$ <?php echo e(number_format($log->valor_pago ?? 0, 2, ',', '.')); ?></strong>
                                </div>
                                
                                <?php if($log->saldo_restante > 0): ?>
                                    <div class="col-md-6">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-exclamation-circle"></i> Saldo Restante
                                        </small>
                                        <strong class="text-warning">R$ <?php echo e(number_format($log->saldo_restante, 2, ',', '.')); ?></strong>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="col-md-6">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-info-circle"></i> Status
                                    </small>
                                    <?php if($log->status == 'fechado'): ?>
                                        <span class="badge bg-success">
                                            <i class="fas fa-check-circle"></i> Fechado
                                        </span>
                                    <?php elseif($log->status == 'perdido'): ?>
                                        <span class="badge bg-danger">
                                            <i class="fas fa-times-circle"></i> Perdido
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-warning">
                                            <i class="fas fa-clock"></i> Em Andamento
                                        </span>
                                    <?php endif; ?>
                                </div>
                                
                                <?php if($log->data_fechamento): ?>
                                    <div class="col-md-6">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-check"></i> Fechado em
                                        </small>
                                        <span class="text-success"><?php echo e(\Carbon\Carbon::parse($log->data_fechamento)->format('d/m/Y H:i:s')); ?></span>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="col-md-12">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-user"></i> Cliente
                                    </small>
                                    <div>
                                        <?php echo e($log->aluno_nome); ?>

                                        <span class="text-muted ms-2">|</span>
                                        <span class="text-muted ms-2"><?php echo e($log->aluno_email); ?></span>
                                        <?php if($log->aluno_celular): ?>
                                            <span class="text-muted ms-2">|</span>
                                            <a href="https://wa.me/55<?php echo e(preg_replace('/[^0-9]/', '', $log->aluno_celular)); ?>" 
                                               target="_blank" class="text-success text-decoration-none ms-2">
                                                <i class="fab fa-whatsapp"></i> <?php echo e($log->aluno_celular); ?>

                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.logs-container {
    padding: 1rem;
}

.log-card {
    background: #fff;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    margin-bottom: 1rem;
    overflow: hidden;
}

.log-card:hover {
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.log-header {
    padding: 1rem;
    background: #f8f9fa;
    border-bottom: 1px solid #e0e0e0;
}

.log-title {
    font-size: 15px;
    margin-bottom: 6px;
}

.log-meta {
    font-size: 13px;
    margin-top: 4px;
}

.log-body {
    padding: 1rem;
}

.font-monospace {
    font-family: 'Courier New', Courier, monospace;
    font-size: 12px;
}
</style>
<?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.especialista', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/especialista/logs-pagamento/index.blade.php ENDPATH**/ ?>