

<?php $__env->startSection('title', 'Contratos'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Contratos</h1>
        <p class="content-subtitle">Gerenciamento de contratos do sistema</p>
    </div>
    <a href="<?php echo e(route('admin.contratos.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Novo Contrato
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Arquivo</th>
                        <th>Tipo</th>
                        <th>Ano</th>
                        <th>Status</th>
                        <th>Upload Por</th>
                        <th>Data Upload</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $contratos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contrato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><code><?php echo e($contrato->arquivo); ?></code></td>
                        <td>
                            <?php
                                $tipos = [
                                    'regular' => 'Regular',
                                    'bolsista' => 'Bolsista',
                                ];
                            ?>
                            <span class="badge bg-info"><?php echo e($tipos[$contrato->tipo] ?? $contrato->tipo); ?></span>
                        </td>
                        <td><?php echo e($contrato->ano ?? '-'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($contrato->ativo ? 'success' : 'secondary'); ?>">
                                <?php echo e($contrato->ativo ? 'Ativo' : 'Inativo'); ?>

                            </span>
                        </td>
                        <td><?php echo e($contrato->criador?->nome ?? '-'); ?></td>
                        <td><?php echo e($contrato->data_upload ? \Carbon\Carbon::parse($contrato->data_upload)->format('d/m/Y H:i') : '-'); ?></td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.contratos.show', $contrato->id)); ?>" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" class="btn btn-outline-<?php echo e($contrato->ativo ? 'warning' : 'success'); ?>" 
                                        onclick="toggleStatus(<?php echo e($contrato->id); ?>)" 
                                        title="<?php echo e($contrato->ativo ? 'Desativar' : 'Ativar'); ?>">
                                    <i class="fas fa-<?php echo e($contrato->ativo ? 'toggle-on' : 'toggle-off'); ?>"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhum contrato encontrado</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($contratos->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($contratos->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleStatus(id) {
    fetch(`/equipe/public/admin/contratos/${id}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/contratos/index.blade.php ENDPATH**/ ?>