

<?php $__env->startSection('title', 'Meus Alunos'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Meus Alunos e Negociações</h1>
    <p class="content-subtitle">
        Gerencie seus alunos e acompanhe todas as negociações em um só lugar
        <br>
        <small class="text-muted">
            <i class="fas fa-info-circle"></i> 
            Total geral: <?php echo e($totalAlunosGeral); ?> aluno(s) | 
            <?php echo e($totalNegociacoesGeral); ?> negociação(ões)
            <?php if($filtroAceite !== 'todos' || $filtroNegociacao !== 'todas' || $filtroPeriodo !== 'todos'): ?>
                | Exibindo: <?php echo e($alunos->count()); ?> (filtrado)
            <?php endif; ?>
        </small>
    </p>
</div>

<!-- Estatísticas -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($totalAlunos); ?></div>
        <div class="stat-label">Total de Alunos</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-handshake"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($totalNegociacoes); ?></div>
        <div class="stat-label">Negociações</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($negociacoesAprovadas); ?></div>
        <div class="stat-label">Aprovadas</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ <?php echo e(number_format($valorTotalNegociado, 0, ',', '.')); ?></div>
        <div class="stat-label">Valor Total</div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('especialista.meus-alunos.index')); ?>" class="row g-3">
            <div class="col-md-3">
                <label class="form-label small"><i class="fas fa-filter me-1"></i>Status de Aceite</label>
                <select name="aceite" class="form-select form-select-sm" onchange="this.form.submit()">
                    <option value="todos" <?php echo e($filtroAceite == 'todos' ? 'selected' : ''); ?>>Todos</option>
                    <option value="realizado" <?php echo e($filtroAceite == 'realizado' ? 'selected' : ''); ?>>Contratos Aceitos</option>
                    <option value="pendente" <?php echo e($filtroAceite == 'pendente' ? 'selected' : ''); ?>>Aceites Pendentes</option>
                </select>
            </div>
            
            <div class="col-md-3">
                <label class="form-label small"><i class="fas fa-handshake me-1"></i>Status de Negociação</label>
                <select name="negociacao" class="form-select form-select-sm" onchange="this.form.submit()">
                    <option value="todas" <?php echo e($filtroNegociacao == 'todas' ? 'selected' : ''); ?>>Todas</option>
                    <option value="pendente" <?php echo e($filtroNegociacao == 'pendente' ? 'selected' : ''); ?>>Pendentes</option>
                    <option value="aprovada" <?php echo e($filtroNegociacao == 'aprovada' ? 'selected' : ''); ?>>Aprovadas</option>
                    <option value="rejeitada" <?php echo e($filtroNegociacao == 'rejeitada' ? 'selected' : ''); ?>>Rejeitadas</option>
                    <option value="cancelada" <?php echo e($filtroNegociacao == 'cancelada' ? 'selected' : ''); ?>>Canceladas</option>
                </select>
            </div>
            
            <div class="col-md-3">
                <label class="form-label small"><i class="fas fa-calendar me-1"></i>Período de Cadastro</label>
                <select name="periodo" class="form-select form-select-sm" onchange="this.form.submit()">
                    <option value="todos" <?php echo e($filtroPeriodo == 'todos' ? 'selected' : ''); ?>>Todo o Período</option>
                    <option value="semana" <?php echo e($filtroPeriodo == 'semana' ? 'selected' : ''); ?>>Última Semana</option>
                    <option value="mes" <?php echo e($filtroPeriodo == 'mes' ? 'selected' : ''); ?>>Último Mês</option>
                    <option value="ano" <?php echo e($filtroPeriodo == 'ano' ? 'selected' : ''); ?>>Último Ano</option>
                </select>
            </div>
            
            <div class="col-md-3 d-flex align-items-end">
                <a href="<?php echo e(route('especialista.meus-alunos.index')); ?>" class="btn btn-secondary btn-sm w-100">
                    <i class="fas fa-redo me-2"></i>Limpar Filtros
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Alunos -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
            <i class="fas fa-users me-2"></i>Meus Alunos e Negociações (<?php echo e($alunos->count()); ?>)
        </h5>
    </div>
    <div class="card-body p-0">
        <?php if($alunos->isEmpty()): ?>
            <div class="alert alert-info text-center m-4">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Nenhum aluno cadastrado ainda.</strong><br>
                Compartilhe seu <a href="<?php echo e(route('especialista.meu-link.index')); ?>">link personalizado</a> para que alunos possam se cadastrar e sejam vinculados a você.
            </div>
        <?php else: ?>
            <div class="alunos-list-container">
                <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="aluno-card aluno-row" data-status="<?php echo e($aluno->status_aceite); ?>">
                        <div class="aluno-card-header" onclick="toggleCard(this)">
                            <div class="d-flex align-items-center flex-grow-1" style="gap: 1rem;">
                                <div class="aluno-avatar">
                                    <div class="avatar-circle">
                                        <?php echo e(strtoupper(substr($aluno->nome, 0, 2))); ?>

                                    </div>
                                </div>
                                <div class="aluno-info-main flex-grow-1">
                                    <div class="aluno-name">
                                        <strong><?php echo e($aluno->nome); ?></strong>
                                        <?php if($aluno->status === 'inativo'): ?>
                                            <span class="badge bg-secondary ms-2">Inativo</span>
                                        <?php endif; ?>
                                        <?php if($aluno->lead_nome): ?>
                                            <span class="badge bg-info ms-2">
                                                <i class="fas fa-user-tag"></i> <?php echo e($aluno->lead_nome); ?>

                                            </span>
                                        <?php endif; ?>
                                        <?php if($aluno->negociacao_status): ?>
                                            <?php
                                                $statusClasses = [
                                                    'pendente' => 'warning',
                                                    'aprovada' => 'success',
                                                    'rejeitada' => 'danger',
                                                    'cancelada' => 'secondary'
                                                ];
                                                $statusIcons = [
                                                    'pendente' => 'clock',
                                                    'aprovada' => 'check-circle',
                                                    'rejeitada' => 'times-circle',
                                                    'cancelada' => 'ban'
                                                ];
                                                $statusTexts = [
                                                    'pendente' => 'Pendente',
                                                    'aprovada' => 'Aprovada',
                                                    'rejeitada' => 'Rejeitada',
                                                    'cancelada' => 'Cancelada'
                                                ];
                                                $class = $statusClasses[$aluno->negociacao_status] ?? 'secondary';
                                                $icon = $statusIcons[$aluno->negociacao_status] ?? 'info-circle';
                                                $text = $statusTexts[$aluno->negociacao_status] ?? $aluno->negociacao_status;
                                            ?>
                                            <span class="badge bg-<?php echo e($class); ?> ms-2">
                                                <i class="fas fa-<?php echo e($icon); ?>"></i> <?php echo e($text); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="aluno-contact">
                                        <span class="text-muted">
                                            <i class="fas fa-envelope"></i> <?php echo e($aluno->email); ?>

                                        </span>
                                        <?php if($aluno->celular): ?>
                                            <span class="text-muted ms-3">
                                                <a href="https://wa.me/55<?php echo e(preg_replace('/[^0-9]/', '', $aluno->celular)); ?>" 
                                                   target="_blank" class="text-success text-decoration-none"
                                                   onclick="event.stopPropagation();">
                                                    <i class="fab fa-whatsapp"></i> <?php echo e($aluno->celular); ?>

                                                </a>
                                            </span>
                                        <?php endif; ?>
                                        <?php if($aluno->valor_total): ?>
                                            <span class="text-success ms-3">
                                                <i class="fas fa-dollar-sign"></i> <strong>R$ <?php echo e(number_format($aluno->valor_total, 2, ',', '.')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="aluno-header-right">
                                <div class="expand-icon">
                                    <i class="fas fa-chevron-down"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="aluno-card-body collapse">
                            <div class="row g-3 p-3">
                                <!-- Informações Básicas -->
                                <div class="col-md-6 col-lg-3">
                                    <div class="info-item">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-calendar"></i> Cadastro
                                        </small>
                                        <span><?php echo e(\Carbon\Carbon::parse($aluno->data_cadastro)->format('d/m/Y')); ?></span>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-3">
                                    <div class="info-item">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-file-contract"></i> Contrato
                                        </small>
                                        <?php if($aluno->status_aceite === 'realizado'): ?>
                                            <span class="badge bg-success">
                                                <i class="fas fa-check"></i> Aceito
                                            </span>
                                        <?php elseif($aluno->status_aceite === 'pendente'): ?>
                                            <span class="badge bg-warning">
                                                <i class="fas fa-clock"></i> Pendente
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">N/A</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-3">
                                    <div class="info-item">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-tag"></i> Tipo
                                        </small>
                                        <?php if($aluno->tipo_contrato): ?>
                                            <span class="badge bg-<?php echo e($aluno->tipo_contrato == 'regular' ? 'primary' : 'success'); ?>">
                                                <?php echo e($aluno->tipo_contrato == 'regular' ? 'Regular' : 'Bolsista'); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-3">
                                    <div class="info-item">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-info-circle"></i> Status Negociação
                                        </small>
                                        <?php if($aluno->negociacao_status): ?>
                                            <?php
                                                $class = $statusClasses[$aluno->negociacao_status] ?? 'secondary';
                                                $icon = $statusIcons[$aluno->negociacao_status] ?? 'info-circle';
                                                $text = $statusTexts[$aluno->negociacao_status] ?? $aluno->negociacao_status;
                                            ?>
                                            <span class="badge bg-<?php echo e($class); ?>">
                                                <i class="fas fa-<?php echo e($icon); ?>"></i> <?php echo e($text); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted">Sem negociação</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <!-- Informações Financeiras -->
                                <?php if($aluno->valor_total || $aluno->negociacao_id): ?>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="info-item">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-dollar-sign"></i> Valor Total
                                            </small>
                                            <strong class="text-success">R$ <?php echo e(number_format($aluno->valor_total ?? 0, 2, ',', '.')); ?></strong>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="info-item">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-hand-holding-usd"></i> Investimento
                                            </small>
                                            <?php if($aluno->investimento_parcial): ?>
                                                <span class="badge bg-warning text-dark">Parcial</span>
                                                <?php if($aluno->valor_pago): ?>
                                                    <br><small class="text-success">R$ <?php echo e(number_format($aluno->valor_pago, 2, ',', '.')); ?></small>
                                                <?php endif; ?>
                                            <?php elseif($aluno->negociacao_id): ?>
                                                <span class="badge bg-info">Total</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="info-item">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-calendar-alt"></i> Parcelas
                                            </small>
                                            <?php if($aluno->num_parcelas && $aluno->valor_total): ?>
                                                <?php
                                                    $numParcelas = $aluno->num_parcelas;
                                                    $valorParcela = $numParcelas > 0 ? ($aluno->valor_total / $numParcelas) : $aluno->valor_total;
                                                ?>
                                                <span><?php echo e($numParcelas); ?>x de R$ <?php echo e(number_format($valorParcela, 2, ',', '.')); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="info-item">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-wallet"></i> Pagamento
                                            </small>
                                            <?php if($aluno->investimento_parcial && $aluno->saldo_restante > 0): ?>
                                                <span class="text-warning">
                                                    <strong>Saldo: R$ <?php echo e(number_format($aluno->saldo_restante, 2, ',', '.')); ?></strong>
                                                </span>
                                            <?php elseif($aluno->negociacao_status == 'aprovada' && $aluno->valor_total): ?>
                                                <?php
                                                    $valorPagoCalc = $aluno->valor_pago ?? 0;
                                                    $percentualRecebido = $aluno->valor_total > 0 ? ($valorPagoCalc / $aluno->valor_total) * 100 : 0;
                                                ?>
                                                <div class="progress" style="height: 18px; font-size: 11px;">
                                                    <div class="progress-bar bg-success" style="width: <?php echo e($percentualRecebido); ?>%">
                                                        <?php echo e(number_format($percentualRecebido, 0)); ?>%
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.alunos-list-container {
    padding: 1rem;
}

.aluno-card {
    background: #fff;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    margin-bottom: 1rem;
    transition: all 0.3s ease;
    overflow: hidden;
}

.aluno-card:hover {
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    border-color: #d0d0d0;
}

.aluno-card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1rem;
    background: #f8f9fa;
    border-bottom: 1px solid #e0e0e0;
    gap: 1rem;
    cursor: pointer;
    transition: background-color 0.2s ease;
    user-select: none;
}

.aluno-card-header:hover {
    background: #f0f0f0;
}

.aluno-header-right {
    display: flex;
    align-items: center;
    gap: 1rem;
    flex-shrink: 0;
}

.expand-icon {
    color: #666;
    transition: transform 0.3s ease;
    font-size: 14px;
    width: 24px;
    height: 24px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.aluno-card.expanded .expand-icon {
    transform: rotate(180deg);
}

.aluno-avatar {
    flex-shrink: 0;
}

.avatar-circle {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 16px;
}

.aluno-info-main {
    flex: 1;
    min-width: 200px;
}

.aluno-name {
    font-size: 16px;
    margin-bottom: 4px;
}

.aluno-contact {
    font-size: 13px;
    margin-top: 4px;
}

.aluno-card-body {
    padding: 0;
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.3s ease, padding 0.3s ease;
}

.aluno-card.expanded .aluno-card-body {
    padding: 1rem;
    max-height: 2000px;
}

.info-item {
    padding: 0.5rem 0;
}

.info-item small {
    font-size: 11px;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.aluno-row[data-status="pendente"] {
    border-left: 4px solid #ffc107;
}

.aluno-row[data-status="realizado"] {
    border-left: 4px solid #28a745;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleCard(header) {
    const card = header.closest('.aluno-card');
    const body = card.querySelector('.aluno-card-body');
    
    if (card.classList.contains('expanded')) {
        card.classList.remove('expanded');
        body.style.maxHeight = '0px';
    } else {
        card.classList.add('expanded');
        const scrollHeight = body.scrollHeight;
        body.style.maxHeight = scrollHeight + 'px';
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.especialista', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/especialista/meus-alunos/index.blade.php ENDPATH**/ ?>