

<?php $__env->startSection('title', 'Gestão de Leads'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Gestão de Leads</h1>
    <p class="content-subtitle">Gerencie e distribua leads entre equipes e especialistas.</p>
</div>

<!-- Container para alertas -->
<div id="alert-container"></div>

<!-- Alertas (para mensagens carregadas com a página) -->
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error') || $errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        <?php echo e(session('error') ?? $errors->first()); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Estatísticas -->
<div class="stats-grid">
    <!-- Total de Leads -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($statsLeads->total_leads ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Total de Leads</div>
    </div>

    <!-- Aguardando -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-clock"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($statsLeads->aguardando ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Aguardando</div>
    </div>

    <!-- Em Negociação -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-handshake"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($statsLeads->em_negociacao ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Em Negociação</div>
    </div>

    <!-- Aprovados -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($statsLeads->aprovada ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Aprovados</div>
    </div>
</div>

<!-- Ações -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Ações</h5>
            <div class="d-flex gap-3 align-items-center">
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#criarLeadModal">
                    <i class="fas fa-plus me-2"></i>Criar Lead
                </button>
                <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#distribuicaoAutomaticaModal">
                    <i class="fas fa-random me-2"></i>Distribuição Automática
                </button>
                <div class="d-flex align-items-center gap-2">
                    <label class="mb-0 text-muted">
                        <i class="fas fa-robot me-1"></i>
                        Distribuição Automática:
                    </label>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="switchDistribuicaoAuto" 
                               style="cursor: pointer; width: 50px; height: 25px;"
                               <?php echo e(($distribuicaoAutomatica ?? '0') == '1' ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="switchDistribuicaoAuto" id="labelDistribuicaoAuto">
                            <span class="badge bg-<?php echo e(($distribuicaoAutomatica ?? '0') == '1' ? 'success' : 'secondary'); ?>" id="badgeDistribuicaoAuto">
                                <?php echo e(($distribuicaoAutomatica ?? '0') == '1' ? 'ATIVO' : 'INATIVO'); ?>

                            </span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Área de Distribuição -->
<div class="row">
    <!-- Coluna de Leads -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header bg-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-clock me-2"></i> Leads Aguardando
                    </h5>
                    <span class="badge bg-warning text-dark"><?php echo e($leadsAguardando->count()); ?></span>
                </div>
            </div>
            <div class="card-body" style="max-height: 600px; overflow-y: auto;">
                <div id="leads-aguardando" class="d-flex flex-column gap-3">
                    <?php echo $__env->make('admin.leads.partials.leads-aguardando', ['leadsAguardando' => $leadsAguardando], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Coluna de Destino -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">
                    <i class="fas fa-bullseye me-2"></i> Destino da Distribuição
                </h5>
            </div>
            <div class="card-body">
                <!-- Dropzone Equipes -->
                <h6 class="mb-2">Equipes</h6>
                <div id="equipes-destino" class="drop-zone border rounded p-3 text-center bg-light mb-4" style="min-height: 150px;">
                    <p class="text-muted mb-0">Arraste um lead aqui para atribuir a uma equipe</p>
                </div>
                
                <!-- Dropzone Especialistas -->
                <h6 class="mb-2">Especialistas</h6>
                <div id="especialistas-destino" class="drop-zone border rounded p-3 text-center bg-light" style="min-height: 150px;">
                    <p class="text-muted mb-0">Arraste um lead aqui para atribuir a um especialista</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tabela de Leads Distribuídos -->
<div class="card mt-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">
            <i class="fas fa-users me-2"></i>
            Leads Distribuídos - Status Atual no Kanban (<?php echo e($leadsDistribuidos->count()); ?>)
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Contato</th>
                        <th>Especialista</th>
                        <th>Status Kanban</th>
                        <th>Última Atualização</th>
                        <th>Data Cadastro</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $leadsDistribuidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><strong><?php echo e($lead->nome); ?></strong></td>
                            <td>
                                <small class="d-block"><?php echo e($lead->email); ?></small>
                                <small class="text-muted"><?php echo e($lead->telefone); ?></small>
                            </td>
                            <td>
                                <?php if($lead->especialista_nome): ?>
                                    <span class="badge bg-primary"><?php echo e($lead->especialista_nome); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                    $statusDisplay = ucfirst(str_replace('_', ' ', $lead->etapa ?? 'novo'));
                                    $badgeClass = 'bg-secondary';
                                    
                                    switch($lead->etapa) {
                                        case 'novo':
                                            $badgeClass = 'bg-warning text-dark';
                                            $statusDisplay = 'Aguardando';
                                            break;
                                        case 'contato':
                                            $badgeClass = 'bg-info text-white';
                                            $statusDisplay = 'Em Contato';
                                            break;
                                        case 'demo':
                                            $badgeClass = 'bg-info text-white';
                                            $statusDisplay = 'Em Negociação';
                                            break;
                                        case 'fechamento':
                                            $badgeClass = 'bg-success';
                                            $statusDisplay = 'Aprovada';
                                            break;
                                        case 'perdido':
                                            $badgeClass = 'bg-danger';
                                            $statusDisplay = 'Perdida';
                                            break;
                                    }
                                ?>
                                <span class="badge <?php echo e($badgeClass); ?>"><?php echo e($statusDisplay); ?></span>
                            </td>
                            <td>
                                <?php if($lead->data_distribuicao): ?>
                                    <?php echo e(\Carbon\Carbon::parse($lead->data_distribuicao)->format('d/m/Y H:i')); ?>

                                <?php elseif($lead->data_cadastro): ?>
                                    <?php echo e(\Carbon\Carbon::parse($lead->data_cadastro)->format('d/m/Y H:i')); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($lead->data_cadastro): ?>
                                    <?php echo e(\Carbon\Carbon::parse($lead->data_cadastro)->format('d/m/Y')); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <i class="fas fa-inbox fa-2x mb-2"></i>
                                <p>Nenhum lead distribuído ainda.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Criar Lead -->
<div class="modal fade" id="criarLeadModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Criar Novo Lead</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo e(route('admin.leads.store')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="action" value="criar_lead">
                
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="nome" class="form-label">Nome Completo <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nome" name="nome" value="<?php echo e(old('nome')); ?>" required>
                            <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email" name="email" value="<?php echo e(old('email')); ?>" required>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="telefone" class="form-label">WhatsApp + DDD <span class="text-danger">*</span></label>
                            <input type="tel" class="form-control <?php $__errorArgs = ['telefone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="telefone" name="telefone" placeholder="(11) 99999-9999" value="<?php echo e(old('telefone')); ?>" required>
                            <?php $__errorArgs = ['telefone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="profissao" class="form-label">Profissão <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['profissao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="profissao" name="profissao" value="<?php echo e(old('profissao')); ?>" required>
                            <?php $__errorArgs = ['profissao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="area_interesse" class="form-label">Área de Interesse <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['area_interesse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="area_interesse" name="area_interesse" required>
                                <option value="">Selecione...</option>
                                <option value="lazer" <?php echo e(old('area_interesse') === 'lazer' ? 'selected' : ''); ?>>Lazer</option>
                                <option value="profissional" <?php echo e(old('area_interesse') === 'profissional' ? 'selected' : ''); ?>>Profissional</option>
                                <option value="outro" <?php echo e(old('area_interesse') === 'outro' ? 'selected' : ''); ?>>Outro</option>
                            </select>
                            <?php $__errorArgs = ['area_interesse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="horario_preferencia" class="form-label">
                                <i class="fas fa-calendar-alt me-1"></i>
                                Data e Horário de Preferência
                            </label>
                            <input type="datetime-local" class="form-control" id="horario_preferencia" name="horario_preferencia" value="<?php echo e(old('horario_preferencia')); ?>">
                        </div>
                        <div class="col-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="referido" name="referido" value="1" <?php echo e(old('referido') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="referido">
                                    <i class="fas fa-user-friends me-1"></i>
                                    Lead Referido (indicado por alguém)
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Criar Lead
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Distribuição Automática -->
<div class="modal fade" id="distribuicaoAutomaticaModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Distribuição Automática</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo e(route('admin.leads.store')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="action" value="distribuir_automatico">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Selecione as equipes:</label>
                        <?php $__currentLoopData = $equipes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="equipe_ids[]" value="<?php echo e($equipe->id); ?>" id="equipe_<?php echo e($equipe->id); ?>">
                                <label class="form-check-label" for="equipe_<?php echo e($equipe->id); ?>">
                                    <?php echo e($equipe->nome); ?>

                                    <small class="text-muted">(<?php echo e($equipe->total_especialistas); ?> especialistas, <?php echo e($equipe->total_leads); ?> leads)</small>
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Distribuir</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Seleção de Equipe -->
<div class="modal fade" id="selecionarEquipeModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Selecionar Equipe</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="lead_id_equipe">
                
                <div class="mb-3">
                    <label class="form-label">Selecione a equipe para distribuir o lead:</label>
                    <div class="equipes-selecao">
                        <?php $__currentLoopData = $equipes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="radio" name="equipe_selecionada" 
                                       id="equipe_sel_<?php echo e($equipe->id); ?>" 
                                       value="<?php echo e($equipe->id); ?>">
                                <label class="form-check-label" for="equipe_sel_<?php echo e($equipe->id); ?>">
                                    <strong><?php echo e($equipe->nome); ?></strong>
                                    <br>
                                    <small class="text-muted">
                                        <?php echo e($equipe->total_especialistas); ?> especialistas | 
                                        <?php echo e($equipe->total_leads); ?> leads
                                    </small>
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarDistribuicaoEquipe()">Distribuir</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Distribuição Manual -->
<div class="modal fade" id="distribuicaoManualModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Distribuir Lead Manualmente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="lead_id_manual">
                
                <div class="mb-3">
                    <label for="especialista_id" class="form-label">Selecione o especialista:</label>
                    <select class="form-select" id="especialista_id" required>
                        <option value="">Selecione um especialista...</option>
                        <?php $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $especialista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($especialista->id); ?>">
                                <?php echo e($especialista->nome); ?> 
                                (<?php echo e($especialista->equipe_nome ?? 'Sem equipe'); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarDistribuicaoEspecialista()">Distribuir</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.lead-card {
    transition: all 0.3s ease;
}
.lead-card:hover {
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}
.lead-card.dragging {
    opacity: 0.5;
}
.drop-zone {
    transition: all 0.3s ease;
}
.drop-zone.drag-over {
    background-color: #e3f2fd !important;
    border-color: #2196f3 !important;
    border-width: 2px !important;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Máscara para telefone
document.addEventListener('DOMContentLoaded', function() {
    const telefoneInput = document.getElementById('telefone');
    if (telefoneInput) {
        telefoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length <= 11) {
                value = value.replace(/(\d{2})(\d{5})(\d{4})/, '($1) $2-$3');
                if (value.length < 14) {
                    value = value.replace(/(\d{2})(\d{4})(\d{4})/, '($1) $2-$3');
                }
            }
            e.target.value = value;
        });
    }
    
    // Limpar formulário quando modal é fechado
    const criarLeadModal = document.getElementById('criarLeadModal');
    if (criarLeadModal) {
        criarLeadModal.addEventListener('hidden.bs.modal', function() {
            this.querySelector('form').reset();
        });
    }

    // Inicializar Drag and Drop
    inicializarDragAndDrop();
});

function distribuirParaEquipe(leadId) {
    const equipeModal = new bootstrap.Modal(document.getElementById('selecionarEquipeModal'));
    document.getElementById('lead_id_equipe').value = leadId;
    equipeModal.show();
}

function distribuirParaEspecialista(leadId) {
    const especialistaModal = new bootstrap.Modal(document.getElementById('distribuicaoManualModal'));
    document.getElementById('lead_id_manual').value = leadId;
    especialistaModal.show();
}

function distribuirLeadAJAX(leadId, tipo, destinoId) {
    if (!leadId) {
        console.error('Lead ID não fornecido!');
        alert('Erro: ID do lead não foi fornecido.');
        return;
    }
    
    console.log('=== DISTRIBUINDO LEAD ===');
    console.log('Lead ID:', leadId);
    console.log('Tipo:', tipo);
    console.log('Destino ID:', destinoId);
    
    const formData = new FormData();
    formData.append('lead_id', leadId);
    
    let url = '';
    if (tipo === 'equipe') {
        formData.append('equipe_id', destinoId);
        url = '<?php echo e(route("admin.leads.distribuir-para-equipe")); ?>';
    } else {
        formData.append('especialista_id', destinoId);
        url = '<?php echo e(route("admin.leads.distribuir-para-especialista")); ?>';
    }
    
    fetch(url, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        console.log('Resposta do servidor:', data);
        
        const alertContainer = document.getElementById('alert-container');
        let alert = document.createElement('div');
        alert.className = `alert alert-${data.success ? 'success' : 'danger'} alert-dismissible fade show mb-4`;
        alert.innerHTML = `<i class="fas ${data.success ? 'fa-check-circle' : 'fa-exclamation-triangle'}"></i> ${data.message || data.error}<button type="button" class="btn-close" data-bs-dismiss="alert"></button>`;
        alertContainer.appendChild(alert);

        if (data.success) {
            console.log('Distribuição bem-sucedida! Atualizando lista...');
            atualizarListaLeads();
        } else {
            console.error('Erro na distribuição:', data.error);
        }

        setTimeout(() => { alert.remove(); }, 5000);
    })
    .catch(error => {
        console.error('Erro na requisição:', error);
        const alertContainer = document.getElementById('alert-container');
        let alert = document.createElement('div');
        alert.className = 'alert alert-danger alert-dismissible fade show mb-4';
        alert.innerHTML = `<i class="fas fa-exclamation-triangle"></i> Erro ao processar a distribuição: ${error.message}<button type="button" class="btn-close" data-bs-dismiss="alert"></button>`;
        alertContainer.appendChild(alert);
    });
}

function confirmarDistribuicaoEquipe() {
    const leadId = document.getElementById('lead_id_equipe').value;
    const equipeSelecionada = document.querySelector('input[name="equipe_selecionada"]:checked');
    if (!equipeSelecionada) {
        alert('Por favor, selecione uma equipe.');
        return;
    }
    distribuirLeadAJAX(leadId, 'equipe', equipeSelecionada.value);
    bootstrap.Modal.getInstance(document.getElementById('selecionarEquipeModal')).hide();
}

function confirmarDistribuicaoEspecialista() {
    const leadId = document.getElementById('lead_id_manual').value;
    const especialistaId = document.getElementById('especialista_id').value;
    if (!especialistaId) {
        alert('Por favor, selecione um especialista.');
        return;
    }
    console.log(`Tentando distribuir Lead ID: ${leadId} para Especialista ID: ${especialistaId}`);
    distribuirLeadAJAX(leadId, 'especialista', especialistaId);
    bootstrap.Modal.getInstance(document.getElementById('distribuicaoManualModal')).hide();
}

function atualizarListaLeads() {
    const alertContainer = document.getElementById('alert-container');
    const loadingIndicator = document.createElement('div');
    loadingIndicator.className = 'alert alert-info';
    loadingIndicator.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Atualizando lista de leads...';
    alertContainer.appendChild(loadingIndicator);
    
    fetch('<?php echo e(route("admin.leads.index")); ?>?ajax=lista', {
        method: 'GET',
        headers: { 
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        const listaAtual = document.querySelector('#leads-aguardando');
        if (listaAtual && data.html) {
            listaAtual.innerHTML = data.html;
        }
        loadingIndicator.remove();
        inicializarDragAndDrop();
    })
    .catch(error => {
        console.error('Erro ao atualizar lista:', error);
        loadingIndicator.remove();
    });
}

function inicializarDragAndDrop() {
    const leadCards = document.querySelectorAll('.lead-card');
    console.log(`Inicializando drag and drop para ${leadCards.length} cards`);
    
    leadCards.forEach(card => {
        const leadId = card.dataset.leadId;
        console.log(`  - Card com Lead ID: ${leadId}`);
        
        card.addEventListener('dragstart', function(e) {
            const draggedLeadId = this.dataset.leadId;
            console.log('Iniciando drag do Lead ID:', draggedLeadId);
            e.dataTransfer.setData('text/plain', draggedLeadId);
            e.dataTransfer.effectAllowed = 'move';
            this.classList.add('dragging');
        });
        
        card.addEventListener('dragend', function() {
            console.log('Finalizando drag');
            this.classList.remove('dragging');
        });
    });
    
    document.querySelectorAll('.drop-zone').forEach(zone => {
        zone.addEventListener('dragover', function(e) {
            e.preventDefault();
            e.dataTransfer.dropEffect = 'move';
            this.classList.add('drag-over');
        });
        
        zone.addEventListener('dragleave', function() {
            this.classList.remove('drag-over');
        });
        
        zone.addEventListener('drop', function(e) {
            e.preventDefault();
            this.classList.remove('drag-over');
            
            const leadId = e.dataTransfer.getData('text/plain');
            console.log('Drop detectado! Lead ID:', leadId, 'Zona:', this.id);
            
            if (!leadId) {
                console.error('ERRO: Lead ID vazio no drop!');
                alert('Erro: ID do lead não foi capturado. Tente novamente.');
                return;
            }
            
            if (this.id === 'equipes-destino') {
                distribuirParaEquipe(leadId);
            } else if (this.id === 'especialistas-destino') {
                distribuirParaEspecialista(leadId);
            }
        });
    });
}

// Switch de Distribuição Automática
document.getElementById('switchDistribuicaoAuto').addEventListener('change', function() {
    const ativo = this.checked ? 1 : 0;
    const badge = document.getElementById('badgeDistribuicaoAuto');
    const label = document.getElementById('labelDistribuicaoAuto');
    
    // Mostrar loading
    badge.className = 'badge bg-warning';
    badge.textContent = 'PROCESSANDO...';
    this.disabled = true;
    
    // Fazer requisição AJAX
    const formData = new FormData();
    formData.append('ativo', ativo);
    
    fetch('<?php echo e(route("admin.leads.toggle-distribuicao-automatica")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Atualizar visual
            badge.className = ativo ? 'badge bg-success' : 'badge bg-secondary';
            badge.textContent = ativo ? 'ATIVO' : 'INATIVO';
            
            // Mostrar alerta de sucesso
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-success alert-dismissible fade show';
            alertDiv.innerHTML = `
                <i class="fas fa-check-circle me-2"></i>
                ${data.message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            document.getElementById('alert-container').appendChild(alertDiv);
            
            // Auto-dismiss após 5 segundos
            setTimeout(() => {
                alertDiv.remove();
            }, 5000);
            
            // Recarregar lista se ativou
            if (ativo) {
                setTimeout(() => {
                    location.reload();
                }, 2000);
            }
        } else {
            // Erro - reverter switch
            this.checked = !this.checked;
            badge.className = 'badge bg-danger';
            badge.textContent = 'ERRO';
            
            alert('Erro: ' + data.message);
            
            setTimeout(() => {
                badge.className = this.checked ? 'badge bg-success' : 'badge bg-secondary';
                badge.textContent = this.checked ? 'ATIVO' : 'INATIVO';
            }, 2000);
        }
        this.disabled = false;
    })
    .catch(error => {
        console.error('Erro:', error);
        this.checked = !this.checked;
        badge.className = 'badge bg-danger';
        badge.textContent = 'ERRO';
        alert('Erro ao processar requisição');
        this.disabled = false;
        
        setTimeout(() => {
            badge.className = this.checked ? 'badge bg-success' : 'badge bg-secondary';
            badge.textContent = this.checked ? 'ATIVO' : 'INATIVO';
        }, 2000);
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/leads/index.blade.php ENDPATH**/ ?>