

<?php $__env->startSection('title', 'Configurações'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Configurações do Sistema</h1>
    <p class="content-subtitle">Configurações gerais e parâmetros do sistema</p>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('admin.configuracoes.update')); ?>">
            <?php echo csrf_field(); ?>
            
            <h5 class="mb-3">Informações Gerais</h5>
            <div class="row mb-4">
                <div class="col-md-6">
                    <label class="form-label">Nome do Sistema</label>
                    <input type="text" class="form-control" name="nome_sistema" value="<?php echo e($config['nome_sistema']); ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Email do Sistema</label>
                    <input type="email" class="form-control" name="email_sistema" value="<?php echo e($config['email_sistema']); ?>" required>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-6">
                    <label class="form-label">Telefone do Sistema</label>
                    <input type="text" class="form-control" name="telefone_sistema" value="<?php echo e($config['telefone_sistema']); ?>">
                </div>
            </div>

            <hr class="my-4">

            <h5 class="mb-3">Configurações de Leads</h5>
            <div class="row mb-4">
                <div class="col-md-4">
                    <label class="form-label">Distribuição Automática</label>
                    <select class="form-select" name="distribuicao_automatica">
                        <option value="1" <?php echo e($config['distribuicao_automatica'] == '1' ? 'selected' : ''); ?>>Ativada</option>
                        <option value="0" <?php echo e($config['distribuicao_automatica'] == '0' ? 'selected' : ''); ?>>Desativada</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Tempo de Resposta (horas)</label>
                    <input type="number" class="form-control" name="tempo_resposta_lead" value="<?php echo e($config['tempo_resposta_lead']); ?>" min="1" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Meta de Conversão (%)</label>
                    <input type="number" class="form-control" name="meta_conversao" value="<?php echo e($config['meta_conversao']); ?>" min="0" max="100" step="0.1" required>
                </div>
            </div>

            <hr class="my-4">

            <h5 class="mb-3">Configurações Financeiras</h5>
            <div class="row mb-4">
                <div class="col-md-6">
                    <label class="form-label">Comissão Padrão (%)</label>
                    <input type="number" class="form-control" name="comissao_padrao" value="<?php echo e($config['comissao_padrao']); ?>" min="0" max="100" step="0.1" required>
                </div>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fas fa-save me-2"></i>Salvar Configurações
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/configuracoes/index.blade.php ENDPATH**/ ?>